/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketMetricsConfigurationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListBucketMetricsConfigurationsResponse.Builder, ListBucketMetricsConfigurationsResponse> {
    private final Boolean isTruncated;

    private final String continuationToken;

    private final String nextContinuationToken;

    private final List<MetricsConfiguration> metricsConfigurationList;

    private ListBucketMetricsConfigurationsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.metricsConfigurationList = builder.metricsConfigurationList;
    }

    /**
     * Indicates whether the returned list of metrics configurations is complete. A value of true indicates that the
     * list is not complete and the NextContinuationToken will be provided for a subsequent request.
     * 
     * @return Indicates whether the returned list of metrics configurations is complete. A value of true indicates that
     *         the list is not complete and the NextContinuationToken will be provided for a subsequent request.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * The marker that is used as a starting point for this metrics configuration list response. This value is present
     * if it was sent in the request.
     * 
     * @return The marker that is used as a starting point for this metrics configuration list response. This value is
     *         present if it was sent in the request.
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * The marker used to continue a metrics configuration listing that has been truncated. Use the
     * NextContinuationToken from a previously truncated list response to continue the listing. The continuation token
     * is an opaque value that Amazon S3 understands.
     * 
     * @return The marker used to continue a metrics configuration listing that has been truncated. Use the
     *         NextContinuationToken from a previously truncated list response to continue the listing. The continuation
     *         token is an opaque value that Amazon S3 understands.
     */
    public String nextContinuationToken() {
        return nextContinuationToken;
    }

    /**
     * The list of metrics configurations for a bucket.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of metrics configurations for a bucket.
     */
    public List<MetricsConfiguration> metricsConfigurationList() {
        return metricsConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((continuationToken() == null) ? 0 : continuationToken().hashCode());
        hashCode = 31 * hashCode + ((nextContinuationToken() == null) ? 0 : nextContinuationToken().hashCode());
        hashCode = 31 * hashCode + ((metricsConfigurationList() == null) ? 0 : metricsConfigurationList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketMetricsConfigurationsResponse)) {
            return false;
        }
        ListBucketMetricsConfigurationsResponse other = (ListBucketMetricsConfigurationsResponse) obj;
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        if (other.nextContinuationToken() != null && !other.nextContinuationToken().equals(this.nextContinuationToken())) {
            return false;
        }
        if (other.metricsConfigurationList() == null ^ this.metricsConfigurationList() == null) {
            return false;
        }
        if (other.metricsConfigurationList() != null && !other.metricsConfigurationList().equals(this.metricsConfigurationList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        if (nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(nextContinuationToken()).append(",");
        }
        if (metricsConfigurationList() != null) {
            sb.append("MetricsConfigurationList: ").append(metricsConfigurationList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "ContinuationToken":
            return Optional.of(clazz.cast(continuationToken()));
        case "NextContinuationToken":
            return Optional.of(clazz.cast(nextContinuationToken()));
        case "MetricsConfigurationList":
            return Optional.of(clazz.cast(metricsConfigurationList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketMetricsConfigurationsResponse> {
        /**
         * Indicates whether the returned list of metrics configurations is complete. A value of true indicates that the
         * list is not complete and the NextContinuationToken will be provided for a subsequent request.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of metrics configurations is complete. A value of true indicates
         *        that the list is not complete and the NextContinuationToken will be provided for a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * The marker that is used as a starting point for this metrics configuration list response. This value is
         * present if it was sent in the request.
         * 
         * @param continuationToken
         *        The marker that is used as a starting point for this metrics configuration list response. This value
         *        is present if it was sent in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * The marker used to continue a metrics configuration listing that has been truncated. Use the
         * NextContinuationToken from a previously truncated list response to continue the listing. The continuation
         * token is an opaque value that Amazon S3 understands.
         * 
         * @param nextContinuationToken
         *        The marker used to continue a metrics configuration listing that has been truncated. Use the
         *        NextContinuationToken from a previously truncated list response to continue the listing. The
         *        continuation token is an opaque value that Amazon S3 understands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextContinuationToken(String nextContinuationToken);

        /**
         * The list of metrics configurations for a bucket.
         * 
         * @param metricsConfigurationList
         *        The list of metrics configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfigurationList(Collection<MetricsConfiguration> metricsConfigurationList);

        /**
         * The list of metrics configurations for a bucket.
         * 
         * @param metricsConfigurationList
         *        The list of metrics configurations for a bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfigurationList(MetricsConfiguration... metricsConfigurationList);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isTruncated;

        private String continuationToken;

        private String nextContinuationToken;

        private List<MetricsConfiguration> metricsConfigurationList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketMetricsConfigurationsResponse model) {
            isTruncated(model.isTruncated);
            continuationToken(model.continuationToken);
            nextContinuationToken(model.nextContinuationToken);
            metricsConfigurationList(model.metricsConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final Collection<MetricsConfiguration.Builder> getMetricsConfigurationList() {
            return metricsConfigurationList != null ? metricsConfigurationList.stream().map(MetricsConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricsConfigurationList(Collection<MetricsConfiguration> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copy(metricsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsConfigurationList(MetricsConfiguration... metricsConfigurationList) {
            metricsConfigurationList(Arrays.asList(metricsConfigurationList));
            return this;
        }

        public final void setMetricsConfigurationList(Collection<MetricsConfiguration.BuilderImpl> metricsConfigurationList) {
            this.metricsConfigurationList = MetricsConfigurationListCopier.copyFromBuilder(metricsConfigurationList);
        }

        @Override
        public ListBucketMetricsConfigurationsResponse build() {
            return new ListBucketMetricsConfigurationsResponse(this);
        }
    }
}
