/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class NotificationConfigurationDeprecated implements
        ToCopyableBuilder<NotificationConfigurationDeprecated.Builder, NotificationConfigurationDeprecated> {
    private final TopicConfigurationDeprecated topicConfiguration;

    private final QueueConfigurationDeprecated queueConfiguration;

    private final CloudFunctionConfiguration cloudFunctionConfiguration;

    private NotificationConfigurationDeprecated(BuilderImpl builder) {
        this.topicConfiguration = builder.topicConfiguration;
        this.queueConfiguration = builder.queueConfiguration;
        this.cloudFunctionConfiguration = builder.cloudFunctionConfiguration;
    }

    /**
     * Returns the value of the TopicConfiguration property for this object.
     * 
     * @return The value of the TopicConfiguration property for this object.
     */
    public TopicConfigurationDeprecated topicConfiguration() {
        return topicConfiguration;
    }

    /**
     * Returns the value of the QueueConfiguration property for this object.
     * 
     * @return The value of the QueueConfiguration property for this object.
     */
    public QueueConfigurationDeprecated queueConfiguration() {
        return queueConfiguration;
    }

    /**
     * Returns the value of the CloudFunctionConfiguration property for this object.
     * 
     * @return The value of the CloudFunctionConfiguration property for this object.
     */
    public CloudFunctionConfiguration cloudFunctionConfiguration() {
        return cloudFunctionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicConfiguration() == null) ? 0 : topicConfiguration().hashCode());
        hashCode = 31 * hashCode + ((queueConfiguration() == null) ? 0 : queueConfiguration().hashCode());
        hashCode = 31 * hashCode + ((cloudFunctionConfiguration() == null) ? 0 : cloudFunctionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfigurationDeprecated)) {
            return false;
        }
        NotificationConfigurationDeprecated other = (NotificationConfigurationDeprecated) obj;
        if (other.topicConfiguration() == null ^ this.topicConfiguration() == null) {
            return false;
        }
        if (other.topicConfiguration() != null && !other.topicConfiguration().equals(this.topicConfiguration())) {
            return false;
        }
        if (other.queueConfiguration() == null ^ this.queueConfiguration() == null) {
            return false;
        }
        if (other.queueConfiguration() != null && !other.queueConfiguration().equals(this.queueConfiguration())) {
            return false;
        }
        if (other.cloudFunctionConfiguration() == null ^ this.cloudFunctionConfiguration() == null) {
            return false;
        }
        if (other.cloudFunctionConfiguration() != null
                && !other.cloudFunctionConfiguration().equals(this.cloudFunctionConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topicConfiguration() != null) {
            sb.append("TopicConfiguration: ").append(topicConfiguration()).append(",");
        }
        if (queueConfiguration() != null) {
            sb.append("QueueConfiguration: ").append(queueConfiguration()).append(",");
        }
        if (cloudFunctionConfiguration() != null) {
            sb.append("CloudFunctionConfiguration: ").append(cloudFunctionConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicConfiguration":
            return Optional.of(clazz.cast(topicConfiguration()));
        case "QueueConfiguration":
            return Optional.of(clazz.cast(queueConfiguration()));
        case "CloudFunctionConfiguration":
            return Optional.of(clazz.cast(cloudFunctionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NotificationConfigurationDeprecated> {
        /**
         * Sets the value of the TopicConfiguration property for this object.
         *
         * @param topicConfiguration
         *        The new value for the TopicConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration);

        /**
         * Sets the value of the QueueConfiguration property for this object.
         *
         * @param queueConfiguration
         *        The new value for the QueueConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration);

        /**
         * Sets the value of the CloudFunctionConfiguration property for this object.
         *
         * @param cloudFunctionConfiguration
         *        The new value for the CloudFunctionConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private TopicConfigurationDeprecated topicConfiguration;

        private QueueConfigurationDeprecated queueConfiguration;

        private CloudFunctionConfiguration cloudFunctionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfigurationDeprecated model) {
            topicConfiguration(model.topicConfiguration);
            queueConfiguration(model.queueConfiguration);
            cloudFunctionConfiguration(model.cloudFunctionConfiguration);
        }

        public final TopicConfigurationDeprecated.Builder getTopicConfiguration() {
            return topicConfiguration != null ? topicConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
            return this;
        }

        public final void setTopicConfiguration(TopicConfigurationDeprecated.BuilderImpl topicConfiguration) {
            this.topicConfiguration = topicConfiguration != null ? topicConfiguration.build() : null;
        }

        public final QueueConfigurationDeprecated.Builder getQueueConfiguration() {
            return queueConfiguration != null ? queueConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
            return this;
        }

        public final void setQueueConfiguration(QueueConfigurationDeprecated.BuilderImpl queueConfiguration) {
            this.queueConfiguration = queueConfiguration != null ? queueConfiguration.build() : null;
        }

        public final CloudFunctionConfiguration.Builder getCloudFunctionConfiguration() {
            return cloudFunctionConfiguration != null ? cloudFunctionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
            return this;
        }

        public final void setCloudFunctionConfiguration(CloudFunctionConfiguration.BuilderImpl cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration != null ? cloudFunctionConfiguration.build() : null;
        }

        @Override
        public NotificationConfigurationDeprecated build() {
            return new NotificationConfigurationDeprecated(this);
        }
    }
}
