/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ObjectVersion implements ToCopyableBuilder<ObjectVersion.Builder, ObjectVersion> {
    private final String eTag;

    private final Long size;

    private final String storageClass;

    private final String key;

    private final String versionId;

    private final Boolean isLatest;

    private final Instant lastModified;

    private final Owner owner;

    private ObjectVersion(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
    }

    /**
     * Returns the value of the ETag property for this object.
     * 
     * @return The value of the ETag property for this object.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * Size in bytes of the object.
     * 
     * @return Size in bytes of the object.
     */
    public Long size() {
        return size;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link ObjectVersionStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see ObjectVersionStorageClass
     */
    public ObjectVersionStorageClass storageClass() {
        return ObjectVersionStorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link ObjectVersionStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see ObjectVersionStorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    /**
     * The object key.
     * 
     * @return The object key.
     */
    public String key() {
        return key;
    }

    /**
     * Version ID of an object.
     * 
     * @return Version ID of an object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Specifies whether the object is (true) or is not (false) the latest version of an object.
     * 
     * @return Specifies whether the object is (true) or is not (false) the latest version of an object.
     */
    public Boolean isLatest() {
        return isLatest;
    }

    /**
     * Date and time the object was last modified.
     * 
     * @return Date and time the object was last modified.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((storageClassString() == null) ? 0 : storageClassString().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((isLatest() == null) ? 0 : isLatest().hashCode());
        hashCode = 31 * hashCode + ((lastModified() == null) ? 0 : lastModified().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectVersion)) {
            return false;
        }
        ObjectVersion other = (ObjectVersion) obj;
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.storageClassString() == null ^ this.storageClassString() == null) {
            return false;
        }
        if (other.storageClassString() != null && !other.storageClassString().equals(this.storageClassString())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isLatest() == null ^ this.isLatest() == null) {
            return false;
        }
        if (other.isLatest() != null && !other.isLatest().equals(this.isLatest())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (storageClassString() != null) {
            sb.append("StorageClass: ").append(storageClassString()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (isLatest() != null) {
            sb.append("IsLatest: ").append(isLatest()).append(",");
        }
        if (lastModified() != null) {
            sb.append("LastModified: ").append(lastModified()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "IsLatest":
            return Optional.of(clazz.cast(isLatest()));
        case "LastModified":
            return Optional.of(clazz.cast(lastModified()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ObjectVersion> {
        /**
         * Sets the value of the ETag property for this object.
         *
         * @param eTag
         *        The new value for the ETag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * Size in bytes of the object.
         * 
         * @param size
         *        Size in bytes of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see ObjectVersionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectVersionStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see ObjectVersionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectVersionStorageClass
         */
        Builder storageClass(ObjectVersionStorageClass storageClass);

        /**
         * The object key.
         * 
         * @param key
         *        The object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Version ID of an object.
         * 
         * @param versionId
         *        Version ID of an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Specifies whether the object is (true) or is not (false) the latest version of an object.
         * 
         * @param isLatest
         *        Specifies whether the object is (true) or is not (false) the latest version of an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatest(Boolean isLatest);

        /**
         * Date and time the object was last modified.
         * 
         * @param lastModified
         *        Date and time the object was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);
    }

    static final class BuilderImpl implements Builder {
        private String eTag;

        private Long size;

        private String storageClass;

        private String key;

        private String versionId;

        private Boolean isLatest;

        private Instant lastModified;

        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectVersion model) {
            eTag(model.eTag);
            size(model.size);
            storageClass(model.storageClass);
            key(model.key);
            versionId(model.versionId);
            isLatest(model.isLatest);
            lastModified(model.lastModified);
            owner(model.owner);
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsLatest() {
            return isLatest;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public final void setIsLatest(Boolean isLatest) {
            this.isLatest = isLatest;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public ObjectVersion build() {
            return new ObjectVersion(this);
        }
    }
}
