/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketLifecycleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketLifecycleRequest.Builder, PutBucketLifecycleRequest> {
    private final String bucket;

    private final String contentMD5;

    private final LifecycleConfiguration lifecycleConfiguration;

    private PutBucketLifecycleRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Returns the value of the LifecycleConfiguration property for this object.
     * 
     * @return The value of the LifecycleConfiguration property for this object.
     */
    public LifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        hashCode = 31 * hashCode + ((lifecycleConfiguration() == null) ? 0 : lifecycleConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleRequest)) {
            return false;
        }
        PutBucketLifecycleRequest other = (PutBucketLifecycleRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.lifecycleConfiguration() == null ^ this.lifecycleConfiguration() == null) {
            return false;
        }
        if (other.lifecycleConfiguration() != null && !other.lifecycleConfiguration().equals(this.lifecycleConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (lifecycleConfiguration() != null) {
            sb.append("LifecycleConfiguration: ").append(lifecycleConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.of(clazz.cast(contentMD5()));
        case "LifecycleConfiguration":
            return Optional.of(clazz.cast(lifecycleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketLifecycleRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Sets the value of the LifecycleConfiguration property for this object.
         *
         * @param lifecycleConfiguration
         *        The new value for the LifecycleConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private LifecycleConfiguration lifecycleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleRequest model) {
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            lifecycleConfiguration(model.lifecycleConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final LifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final void setLifecycleConfiguration(LifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public PutBucketLifecycleRequest build() {
            return new PutBucketLifecycleRequest(this);
        }
    }
}
