/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Rule implements ToCopyableBuilder<Rule.Builder, Rule> {
    private final LifecycleExpiration expiration;

    private final String id;

    private final String prefix;

    private final String status;

    private final Transition transition;

    private final NoncurrentVersionTransition noncurrentVersionTransition;

    private final NoncurrentVersionExpiration noncurrentVersionExpiration;

    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private Rule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.status = builder.status;
        this.transition = builder.transition;
        this.noncurrentVersionTransition = builder.noncurrentVersionTransition;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    /**
     * Returns the value of the Expiration property for this object.
     * 
     * @return The value of the Expiration property for this object.
     */
    public LifecycleExpiration expiration() {
        return expiration;
    }

    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     * 
     * @return Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    public String id() {
        return id;
    }

    /**
     * Prefix identifying one or more objects to which the rule applies.
     * 
     * @return Prefix identifying one or more objects to which the rule applies.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(status);
    }

    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExpirationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
     *         applied.
     * @see ExpirationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * Returns the value of the Transition property for this object.
     * 
     * @return The value of the Transition property for this object.
     */
    public Transition transition() {
        return transition;
    }

    /**
     * Returns the value of the NoncurrentVersionTransition property for this object.
     * 
     * @return The value of the NoncurrentVersionTransition property for this object.
     */
    public NoncurrentVersionTransition noncurrentVersionTransition() {
        return noncurrentVersionTransition;
    }

    /**
     * Returns the value of the NoncurrentVersionExpiration property for this object.
     * 
     * @return The value of the NoncurrentVersionExpiration property for this object.
     */
    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return noncurrentVersionExpiration;
    }

    /**
     * Returns the value of the AbortIncompleteMultipartUpload property for this object.
     * 
     * @return The value of the AbortIncompleteMultipartUpload property for this object.
     */
    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return abortIncompleteMultipartUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((expiration() == null) ? 0 : expiration().hashCode());
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        hashCode = 31 * hashCode + ((transition() == null) ? 0 : transition().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionTransition() == null) ? 0 : noncurrentVersionTransition().hashCode());
        hashCode = 31 * hashCode + ((noncurrentVersionExpiration() == null) ? 0 : noncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + ((abortIncompleteMultipartUpload() == null) ? 0 : abortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.transition() == null ^ this.transition() == null) {
            return false;
        }
        if (other.transition() != null && !other.transition().equals(this.transition())) {
            return false;
        }
        if (other.noncurrentVersionTransition() == null ^ this.noncurrentVersionTransition() == null) {
            return false;
        }
        if (other.noncurrentVersionTransition() != null
                && !other.noncurrentVersionTransition().equals(this.noncurrentVersionTransition())) {
            return false;
        }
        if (other.noncurrentVersionExpiration() == null ^ this.noncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.noncurrentVersionExpiration() != null
                && !other.noncurrentVersionExpiration().equals(this.noncurrentVersionExpiration())) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() == null ^ this.abortIncompleteMultipartUpload() == null) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() != null
                && !other.abortIncompleteMultipartUpload().equals(this.abortIncompleteMultipartUpload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (expiration() != null) {
            sb.append("Expiration: ").append(expiration()).append(",");
        }
        if (id() != null) {
            sb.append("ID: ").append(id()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (transition() != null) {
            sb.append("Transition: ").append(transition()).append(",");
        }
        if (noncurrentVersionTransition() != null) {
            sb.append("NoncurrentVersionTransition: ").append(noncurrentVersionTransition()).append(",");
        }
        if (noncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(noncurrentVersionExpiration()).append(",");
        }
        if (abortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(abortIncompleteMultipartUpload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expiration":
            return Optional.of(clazz.cast(expiration()));
        case "ID":
            return Optional.of(clazz.cast(id()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "Transition":
            return Optional.of(clazz.cast(transition()));
        case "NoncurrentVersionTransition":
            return Optional.of(clazz.cast(noncurrentVersionTransition()));
        case "NoncurrentVersionExpiration":
            return Optional.of(clazz.cast(noncurrentVersionExpiration()));
        case "AbortIncompleteMultipartUpload":
            return Optional.of(clazz.cast(abortIncompleteMultipartUpload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Rule> {
        /**
         * Sets the value of the Expiration property for this object.
         *
         * @param expiration
         *        The new value for the Expiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(LifecycleExpiration expiration);

        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         * 
         * @param id
         *        Unique identifier for the rule. The value cannot be longer than 255 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Prefix identifying one or more objects to which the rule applies.
         * 
         * @param prefix
         *        Prefix identifying one or more objects to which the rule applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(String status);

        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         * 
         * @param status
         *        If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being
         *        applied.
         * @see ExpirationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationStatus
         */
        Builder status(ExpirationStatus status);

        /**
         * Sets the value of the Transition property for this object.
         *
         * @param transition
         *        The new value for the Transition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transition(Transition transition);

        /**
         * Sets the value of the NoncurrentVersionTransition property for this object.
         *
         * @param noncurrentVersionTransition
         *        The new value for the NoncurrentVersionTransition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition);

        /**
         * Sets the value of the NoncurrentVersionExpiration property for this object.
         *
         * @param noncurrentVersionExpiration
         *        The new value for the NoncurrentVersionExpiration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration);

        /**
         * Sets the value of the AbortIncompleteMultipartUpload property for this object.
         *
         * @param abortIncompleteMultipartUpload
         *        The new value for the AbortIncompleteMultipartUpload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload);
    }

    static final class BuilderImpl implements Builder {
        private LifecycleExpiration expiration;

        private String id;

        private String prefix;

        private String status;

        private Transition transition;

        private NoncurrentVersionTransition noncurrentVersionTransition;

        private NoncurrentVersionExpiration noncurrentVersionExpiration;

        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            expiration(model.expiration);
            id(model.id);
            prefix(model.prefix);
            status(model.status);
            transition(model.transition);
            noncurrentVersionTransition(model.noncurrentVersionTransition);
            noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return expiration != null ? expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Transition.Builder getTransition() {
            return transition != null ? transition.toBuilder() : null;
        }

        @Override
        public final Builder transition(Transition transition) {
            this.transition = transition;
            return this;
        }

        public final void setTransition(Transition.BuilderImpl transition) {
            this.transition = transition != null ? transition.build() : null;
        }

        public final NoncurrentVersionTransition.Builder getNoncurrentVersionTransition() {
            return noncurrentVersionTransition != null ? noncurrentVersionTransition.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
            return this;
        }

        public final void setNoncurrentVersionTransition(NoncurrentVersionTransition.BuilderImpl noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition != null ? noncurrentVersionTransition.build() : null;
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return noncurrentVersionExpiration != null ? noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(
                AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build()
                    : null;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }
    }
}
