/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StorageClassAnalysis implements ToCopyableBuilder<StorageClassAnalysis.Builder, StorageClassAnalysis> {
    private final StorageClassAnalysisDataExport dataExport;

    private StorageClassAnalysis(BuilderImpl builder) {
        this.dataExport = builder.dataExport;
    }

    /**
     * A container used to describe how data related to the storage class analysis should be exported.
     * 
     * @return A container used to describe how data related to the storage class analysis should be exported.
     */
    public StorageClassAnalysisDataExport dataExport() {
        return dataExport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dataExport() == null) ? 0 : dataExport().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageClassAnalysis)) {
            return false;
        }
        StorageClassAnalysis other = (StorageClassAnalysis) obj;
        if (other.dataExport() == null ^ this.dataExport() == null) {
            return false;
        }
        if (other.dataExport() != null && !other.dataExport().equals(this.dataExport())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (dataExport() != null) {
            sb.append("DataExport: ").append(dataExport()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataExport":
            return Optional.of(clazz.cast(dataExport()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StorageClassAnalysis> {
        /**
         * A container used to describe how data related to the storage class analysis should be exported.
         * 
         * @param dataExport
         *        A container used to describe how data related to the storage class analysis should be exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExport(StorageClassAnalysisDataExport dataExport);
    }

    static final class BuilderImpl implements Builder {
        private StorageClassAnalysisDataExport dataExport;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageClassAnalysis model) {
            dataExport(model.dataExport);
        }

        public final StorageClassAnalysisDataExport.Builder getDataExport() {
            return dataExport != null ? dataExport.toBuilder() : null;
        }

        @Override
        public final Builder dataExport(StorageClassAnalysisDataExport dataExport) {
            this.dataExport = dataExport;
            return this;
        }

        public final void setDataExport(StorageClassAnalysisDataExport.BuilderImpl dataExport) {
            this.dataExport = dataExport != null ? dataExport.build() : null;
        }

        @Override
        public StorageClassAnalysis build() {
            return new StorageClassAnalysis(this);
        }
    }
}
