/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UploadPartRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UploadPartRequest.Builder, UploadPartRequest> {
    private final String bucket;

    private final Long contentLength;

    private final String contentMD5;

    private final String key;

    private final Integer partNumber;

    private final String uploadId;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKey;

    private final String sseCustomerKeyMD5;

    private final String requestPayer;

    private UploadPartRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
    }

    /**
     * Name of the bucket to which the multipart upload was initiated.
     * 
     * @return Name of the bucket to which the multipart upload was initiated.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically.
     * 
     * @return Size of the body in bytes. This parameter is useful when the size of the body cannot be determined
     *         automatically.
     */
    public Long contentLength() {
        return contentLength;
    }

    /**
     * The base64-encoded 128-bit MD5 digest of the part data.
     * 
     * @return The base64-encoded 128-bit MD5 digest of the part data.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * Object key for which the multipart upload was initiated.
     * 
     * @return Object key for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * Part number of part being uploaded. This is a positive integer between 1 and 10,000.
     * 
     * @return Part number of part being uploaded. This is a positive integer between 1 and 10,000.
     */
    public Integer partNumber() {
        return partNumber;
    }

    /**
     * Upload ID identifying the multipart upload whose part is being uploaded.
     * 
     * @return Upload ID identifying the multipart upload whose part is being uploaded.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
     * store the object and then it is discarded; Amazon does not store the encryption key. The key must be appropriate
     * for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm header. This must
     * be the same encryption key specified in the initiate multipart upload request.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
     *         used to store the object and then it is discarded; Amazon does not store the encryption key. The key must
     *         be appropriate for use with the algorithm specified in the
     *         x-amz-server-side​-encryption​-customer-algorithm header. This must be the same encryption key specified
     *         in the initiate multipart upload request.
     */
    public String sseCustomerKey() {
        return sseCustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerString() {
        return requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((contentLength() == null) ? 0 : contentLength().hashCode());
        hashCode = 31 * hashCode + ((contentMD5() == null) ? 0 : contentMD5().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((partNumber() == null) ? 0 : partNumber().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKey() == null) ? 0 : sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((requestPayerString() == null) ? 0 : requestPayerString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartRequest)) {
            return false;
        }
        UploadPartRequest other = (UploadPartRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentLength() == null ^ this.contentLength() == null) {
            return false;
        }
        if (other.contentLength() != null && !other.contentLength().equals(this.contentLength())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        if (other.requestPayerString() != null && !other.requestPayerString().equals(this.requestPayerString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (contentLength() != null) {
            sb.append("ContentLength: ").append(contentLength()).append(",");
        }
        if (contentMD5() != null) {
            sb.append("ContentMD5: ").append(contentMD5()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (partNumber() != null) {
            sb.append("PartNumber: ").append(partNumber()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(sseCustomerKey()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (requestPayerString() != null) {
            sb.append("RequestPayer: ").append(requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "ContentLength":
            return Optional.of(clazz.cast(contentLength()));
        case "ContentMD5":
            return Optional.of(clazz.cast(contentMD5()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "PartNumber":
            return Optional.of(clazz.cast(partNumber()));
        case "UploadId":
            return Optional.of(clazz.cast(uploadId()));
        case "SSECustomerAlgorithm":
            return Optional.of(clazz.cast(sseCustomerAlgorithm()));
        case "SSECustomerKey":
            return Optional.of(clazz.cast(sseCustomerKey()));
        case "SSECustomerKeyMD5":
            return Optional.of(clazz.cast(sseCustomerKeyMD5()));
        case "RequestPayer":
            return Optional.of(clazz.cast(requestPayerString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UploadPartRequest> {
        /**
         * Name of the bucket to which the multipart upload was initiated.
         * 
         * @param bucket
         *        Name of the bucket to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Size of the body in bytes. This parameter is useful when the size of the body cannot be determined
         * automatically.
         * 
         * @param contentLength
         *        Size of the body in bytes. This parameter is useful when the size of the body cannot be determined
         *        automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * The base64-encoded 128-bit MD5 digest of the part data.
         * 
         * @param contentMD5
         *        The base64-encoded 128-bit MD5 digest of the part data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * Object key for which the multipart upload was initiated.
         * 
         * @param key
         *        Object key for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Part number of part being uploaded. This is a positive integer between 1 and 10,000.
         * 
         * @param partNumber
         *        Part number of part being uploaded. This is a positive integer between 1 and 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);

        /**
         * Upload ID identifying the multipart upload whose part is being uploaded.
         * 
         * @param uploadId
         *        Upload ID identifying the multipart upload whose part is being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * 
         * @param sseCustomerAlgorithm
         *        Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
         * store the object and then it is discarded; Amazon does not store the encryption key. The key must be
         * appropriate for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
         * header. This must be the same encryption key specified in the initiate multipart upload request.
         * 
         * @param sseCustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
         *        used to store the object and then it is discarded; Amazon does not store the encryption key. The key
         *        must be appropriate for use with the algorithm specified in the
         *        x-amz-server-side​-encryption​-customer-algorithm header. This must be the same encryption key
         *        specified in the initiate multipart upload request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKey(String sseCustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param sseCustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private Long contentLength;

        private String contentMD5;

        private String key;

        private Integer partNumber;

        private String uploadId;

        private String sseCustomerAlgorithm;

        private String sseCustomerKey;

        private String sseCustomerKeyMD5;

        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartRequest model) {
            bucket(model.bucket);
            contentLength(model.contentLength);
            contentMD5(model.contentMD5);
            key(model.key);
            partNumber(model.partNumber);
            uploadId(model.uploadId);
            sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            sseCustomerKey(model.sseCustomerKey);
            sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }
    }
}
