/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * PutObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutObjectRequestMarshaller implements Marshaller<Request<PutObjectRequest>, PutObjectRequest> {

    public Request<PutObjectRequest> marshall(PutObjectRequest putObjectRequest) {

        if (putObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutObjectRequest> request = new DefaultRequest<PutObjectRequest>(putObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putObjectRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(putObjectRequest.aclString()));
        }

        if (putObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString(putObjectRequest.cacheControl()));
        }

        if (putObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString(putObjectRequest.contentDisposition()));
        }

        if (putObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString(putObjectRequest.contentEncoding()));
        }

        if (putObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString(putObjectRequest.contentLanguage()));
        }

        if (putObjectRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong(putObjectRequest.contentLength()));
        }

        if (putObjectRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putObjectRequest.contentMD5()));
        }

        if (putObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(putObjectRequest.contentType()));
        }

        if (putObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromInstant(putObjectRequest.expires()));
        }

        if (putObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(putObjectRequest.grantFullControl()));
        }

        if (putObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(putObjectRequest.grantRead()));
        }

        if (putObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(putObjectRequest.grantReadACP()));
        }

        if (putObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(putObjectRequest.grantWriteACP()));
        }

        if (putObjectRequest.serverSideEncryptionString() != null) {
            request.addHeader("x-amz-server-side-encryption",
                    StringUtils.fromString(putObjectRequest.serverSideEncryptionString()));
        }

        if (putObjectRequest.storageClassString() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString(putObjectRequest.storageClassString()));
        }

        if (putObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location",
                    StringUtils.fromString(putObjectRequest.websiteRedirectLocation()));
        }

        if (putObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(putObjectRequest.sseCustomerAlgorithm()));
        }

        if (putObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(putObjectRequest.sseCustomerKey()));
        }

        if (putObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(putObjectRequest.sseCustomerKeyMD5()));
        }

        if (putObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id",
                    StringUtils.fromString(putObjectRequest.ssekmsKeyId()));
        }

        if (putObjectRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(putObjectRequest.requestPayerString()));
        }

        if (putObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString(putObjectRequest.tagging()));
        }

        if (putObjectRequest.metadata() != null) {
            putObjectRequest.metadata().entrySet().forEach(e -> {
                if (e.getKey().startsWith("x-amz-meta-")) {
                    request.addHeader(e.getKey(), e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + e.getKey(), e.getValue());
                }
            });
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                putObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }

        return request;
    }

}