/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * QueueConfigurationDeprecated StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class QueueConfigurationDeprecatedUnmarshaller implements
        Unmarshaller<QueueConfigurationDeprecated, StaxUnmarshallerContext> {

    public QueueConfigurationDeprecated unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueueConfigurationDeprecated.Builder queueConfigurationDeprecated = QueueConfigurationDeprecated.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> events = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                queueConfigurationDeprecated.events(events);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Id", targetDepth)) {
                    queueConfigurationDeprecated.id(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    queueConfigurationDeprecated.event(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Event", targetDepth)) {
                    if (events == null) {
                        events = new ArrayList<>();
                    }
                    events.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Queue", targetDepth)) {
                    queueConfigurationDeprecated.queue(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    queueConfigurationDeprecated.events(events);
                    break;
                }
            }
        }
        return queueConfigurationDeprecated.build();
    }

    private static final QueueConfigurationDeprecatedUnmarshaller INSTANCE = new QueueConfigurationDeprecatedUnmarshaller();

    public static QueueConfigurationDeprecatedUnmarshaller getInstance() {
        return INSTANCE;
    }
}
