/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import static java.util.stream.Collectors.toList;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class BucketsCopier {
    static List<Bucket> copy(Collection<Bucket> bucketsParam) {
        if (bucketsParam == null) {
            return null;
        }
        List<Bucket> bucketsParamCopy = bucketsParam.stream().collect(toList());
        return Collections.unmodifiableList(bucketsParamCopy);
    }

    static List<Bucket> copyFromBuilder(Collection<? extends Bucket.Builder> bucketsParam) {
        if (bucketsParam == null) {
            return null;
        }
        return copy(bucketsParam.stream().map(Bucket.Builder::build).collect(toList()));
    }
}
