/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteObjectTaggingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteObjectTaggingRequest.Builder, DeleteObjectTaggingRequest> {
    private final String bucket;

    private final String key;

    private final String versionId;

    private DeleteObjectTaggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.versionId = builder.versionId;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * The versionId of the object that the tag-set will be removed from.
     * 
     * @return The versionId of the object that the tag-set will be removed from.
     */
    public String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectTaggingRequest)) {
            return false;
        }
        DeleteObjectTaggingRequest other = (DeleteObjectTaggingRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(versionId(), other.versionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteObjectTaggingRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * The versionId of the object that the tag-set will be removed from.
         * 
         * @param versionId
         *        The versionId of the object that the tag-set will be removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectTaggingRequest model) {
            bucket(model.bucket);
            key(model.key);
            versionId(model.versionId);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public DeleteObjectTaggingRequest build() {
            return new DeleteObjectTaggingRequest(this);
        }
    }
}
