/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketMetricsConfigurationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListBucketMetricsConfigurationsRequest.Builder, ListBucketMetricsConfigurationsRequest> {
    private final String bucket;

    private final String continuationToken;

    private ListBucketMetricsConfigurationsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * The name of the bucket containing the metrics configurations to retrieve.
     * 
     * @return The name of the bucket containing the metrics configurations to retrieve.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The marker that is used to continue a metrics configuration listing that has been truncated. Use the
     * NextContinuationToken from a previously truncated list response to continue the listing. The continuation token
     * is an opaque value that Amazon S3 understands.
     * 
     * @return The marker that is used to continue a metrics configuration listing that has been truncated. Use the
     *         NextContinuationToken from a previously truncated list response to continue the listing. The continuation
     *         token is an opaque value that Amazon S3 understands.
     */
    public String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketMetricsConfigurationsRequest)) {
            return false;
        }
        ListBucketMetricsConfigurationsRequest other = (ListBucketMetricsConfigurationsRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(continuationToken(), other.continuationToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (continuationToken() != null) {
            sb.append("ContinuationToken: ").append(continuationToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "ContinuationToken":
            return Optional.of(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListBucketMetricsConfigurationsRequest> {
        /**
         * The name of the bucket containing the metrics configurations to retrieve.
         * 
         * @param bucket
         *        The name of the bucket containing the metrics configurations to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The marker that is used to continue a metrics configuration listing that has been truncated. Use the
         * NextContinuationToken from a previously truncated list response to continue the listing. The continuation
         * token is an opaque value that Amazon S3 understands.
         * 
         * @param continuationToken
         *        The marker that is used to continue a metrics configuration listing that has been truncated. Use the
         *        NextContinuationToken from a previously truncated list response to continue the listing. The
         *        continuation token is an opaque value that Amazon S3 understands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketMetricsConfigurationsRequest model) {
            bucket(model.bucket);
            continuationToken(model.continuationToken);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public ListBucketMetricsConfigurationsRequest build() {
            return new ListBucketMetricsConfigurationsRequest(this);
        }
    }
}
