/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketAccelerateConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketAccelerateConfigurationRequest.Builder, PutBucketAccelerateConfigurationRequest> {
    private final String bucket;

    private final AccelerateConfiguration accelerateConfiguration;

    private PutBucketAccelerateConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.accelerateConfiguration = builder.accelerateConfiguration;
    }

    /**
     * Name of the bucket for which the accelerate configuration is set.
     * 
     * @return Name of the bucket for which the accelerate configuration is set.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Specifies the Accelerate Configuration you want to set for the bucket.
     * 
     * @return Specifies the Accelerate Configuration you want to set for the bucket.
     */
    public AccelerateConfiguration accelerateConfiguration() {
        return accelerateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(accelerateConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAccelerateConfigurationRequest)) {
            return false;
        }
        PutBucketAccelerateConfigurationRequest other = (PutBucketAccelerateConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket())
                && Objects.equals(accelerateConfiguration(), other.accelerateConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (accelerateConfiguration() != null) {
            sb.append("AccelerateConfiguration: ").append(accelerateConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "AccelerateConfiguration":
            return Optional.of(clazz.cast(accelerateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
        /**
         * Name of the bucket for which the accelerate configuration is set.
         * 
         * @param bucket
         *        Name of the bucket for which the accelerate configuration is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Specifies the Accelerate Configuration you want to set for the bucket.
         * 
         * @param accelerateConfiguration
         *        Specifies the Accelerate Configuration you want to set for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration);

        /**
         * Specifies the Accelerate Configuration you want to set for the bucket. This is a convenience that creates an
         * instance of the {@link AccelerateConfiguration.Builder} avoiding the need to create one manually via
         * {@link AccelerateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #accelerateConfiguration(AccelerateConfiguration)}.
         * 
         * @param accelerateConfiguration
         *        a consumer that will call methods on {@link AccelerateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerateConfiguration(AccelerateConfiguration)
         */
        default Builder accelerateConfiguration(Consumer<AccelerateConfiguration.Builder> accelerateConfiguration) {
            return accelerateConfiguration(AccelerateConfiguration.builder().apply(accelerateConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private AccelerateConfiguration accelerateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAccelerateConfigurationRequest model) {
            bucket(model.bucket);
            accelerateConfiguration(model.accelerateConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final AccelerateConfiguration.Builder getAccelerateConfiguration() {
            return accelerateConfiguration != null ? accelerateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        public final void setAccelerateConfiguration(AccelerateConfiguration.BuilderImpl accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration != null ? accelerateConfiguration.build() : null;
        }

        @Override
        public PutBucketAccelerateConfigurationRequest build() {
            return new PutBucketAccelerateConfigurationRequest(this);
        }
    }
}
