/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketLifecycleConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutBucketLifecycleConfigurationRequest.Builder, PutBucketLifecycleConfigurationRequest> {
    private final String bucket;

    private final BucketLifecycleConfiguration lifecycleConfiguration;

    private PutBucketLifecycleConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the LifecycleConfiguration property for this object.
     * 
     * @return The value of the LifecycleConfiguration property for this object.
     */
    public BucketLifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleConfigurationRequest)) {
            return false;
        }
        PutBucketLifecycleConfigurationRequest other = (PutBucketLifecycleConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket())
                && Objects.equals(lifecycleConfiguration(), other.lifecycleConfiguration());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (lifecycleConfiguration() != null) {
            sb.append("LifecycleConfiguration: ").append(lifecycleConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "LifecycleConfiguration":
            return Optional.of(clazz.cast(lifecycleConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the LifecycleConfiguration property for this object.
         *
         * @param lifecycleConfiguration
         *        The new value for the LifecycleConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration);

        /**
         * Sets the value of the LifecycleConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link BucketLifecycleConfiguration.Builder} avoiding
         * the need to create one manually via {@link BucketLifecycleConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketLifecycleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleConfiguration(BucketLifecycleConfiguration)}.
         * 
         * @param lifecycleConfiguration
         *        a consumer that will call methods on {@link BucketLifecycleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleConfiguration(BucketLifecycleConfiguration)
         */
        default Builder lifecycleConfiguration(Consumer<BucketLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return lifecycleConfiguration(BucketLifecycleConfiguration.builder().apply(lifecycleConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private BucketLifecycleConfiguration lifecycleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleConfigurationRequest model) {
            bucket(model.bucket);
            lifecycleConfiguration(model.lifecycleConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final void setLifecycleConfiguration(BucketLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public PutBucketLifecycleConfigurationRequest build() {
            return new PutBucketLifecycleConfigurationRequest(this);
        }
    }
}
