/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class QueueConfigurationDeprecated implements
        ToCopyableBuilder<QueueConfigurationDeprecated.Builder, QueueConfigurationDeprecated> {
    private final String id;

    private final String event;

    private final List<String> events;

    private final String queue;

    private QueueConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.queue = builder.queue;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public String id() {
        return id;
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see Event
     */
    public Event event() {
        return Event.fromValue(event);
    }

    /**
     * Returns the value of the Event property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link Event#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventString}.
     * </p>
     * 
     * @return The value of the Event property for this object.
     * @see Event
     */
    public String eventString() {
        return event;
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<Event> events() {
        return TypeConverter.convert(events, Event::fromValue);
    }

    /**
     * Returns the value of the Events property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Events property for this object.
     */
    public List<String> eventsStrings() {
        return events;
    }

    /**
     * Returns the value of the Queue property for this object.
     * 
     * @return The value of the Queue property for this object.
     */
    public String queue() {
        return queue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(eventString());
        hashCode = 31 * hashCode + Objects.hashCode(eventsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfigurationDeprecated)) {
            return false;
        }
        QueueConfigurationDeprecated other = (QueueConfigurationDeprecated) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(eventString(), other.eventString())
                && Objects.equals(eventsStrings(), other.eventsStrings()) && Objects.equals(queue(), other.queue());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (eventString() != null) {
            sb.append("Event: ").append(eventString()).append(",");
        }
        if (eventsStrings() != null) {
            sb.append("Events: ").append(eventsStrings()).append(",");
        }
        if (queue() != null) {
            sb.append("Queue: ").append(queue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Event":
            return Optional.of(clazz.cast(eventString()));
        case "Events":
            return Optional.of(clazz.cast(eventsStrings()));
        case "Queue":
            return Optional.of(clazz.cast(queue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, QueueConfigurationDeprecated> {
        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @see Event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<String> events);

        /**
         * Sets the value of the Events property for this object.
         *
         * @param events
         *        The new value for the Events property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String... events);

        /**
         * Sets the value of the Queue property for this object.
         *
         * @param queue
         *        The new value for the Queue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(String queue);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String event;

        private List<String> events;

        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfigurationDeprecated model) {
            id(model.id);
            event(model.event);
            events(model.events);
            queue(model.queue);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getQueue() {
            return queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public QueueConfigurationDeprecated build() {
            return new QueueConfigurationDeprecated(this);
        }
    }
}
