/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RoutingRule implements ToCopyableBuilder<RoutingRule.Builder, RoutingRule> {
    private final Condition condition;

    private final Redirect redirect;

    private RoutingRule(BuilderImpl builder) {
        this.condition = builder.condition;
        this.redirect = builder.redirect;
    }

    /**
     * A container for describing a condition that must be met for the specified redirect to apply. For example, 1. If
     * request is for pages in the /docs folder, redirect to the /documents folder. 2. If request results in HTTP error
     * 4xx, redirect request to another host where you might process the error.
     * 
     * @return A container for describing a condition that must be met for the specified redirect to apply. For example,
     *         1. If request is for pages in the /docs folder, redirect to the /documents folder. 2. If request results
     *         in HTTP error 4xx, redirect request to another host where you might process the error.
     */
    public Condition condition() {
        return condition;
    }

    /**
     * Container for redirect information. You can redirect requests to another host, to another page, or with another
     * protocol. In the event of an error, you can can specify a different error code to return.
     * 
     * @return Container for redirect information. You can redirect requests to another host, to another page, or with
     *         another protocol. In the event of an error, you can can specify a different error code to return.
     */
    public Redirect redirect() {
        return redirect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(redirect());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingRule)) {
            return false;
        }
        RoutingRule other = (RoutingRule) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(redirect(), other.redirect());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (condition() != null) {
            sb.append("Condition: ").append(condition()).append(",");
        }
        if (redirect() != null) {
            sb.append("Redirect: ").append(redirect()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.of(clazz.cast(condition()));
        case "Redirect":
            return Optional.of(clazz.cast(redirect()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RoutingRule> {
        /**
         * A container for describing a condition that must be met for the specified redirect to apply. For example, 1.
         * If request is for pages in the /docs folder, redirect to the /documents folder. 2. If request results in HTTP
         * error 4xx, redirect request to another host where you might process the error.
         * 
         * @param condition
         *        A container for describing a condition that must be met for the specified redirect to apply. For
         *        example, 1. If request is for pages in the /docs folder, redirect to the /documents folder. 2. If
         *        request results in HTTP error 4xx, redirect request to another host where you might process the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * A container for describing a condition that must be met for the specified redirect to apply. For example, 1.
         * If request is for pages in the /docs folder, redirect to the /documents folder. 2. If request results in HTTP
         * error 4xx, redirect request to another host where you might process the error. This is a convenience that
         * creates an instance of the {@link Condition.Builder} avoiding the need to create one manually via
         * {@link Condition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().apply(condition).build());
        }

        /**
         * Container for redirect information. You can redirect requests to another host, to another page, or with
         * another protocol. In the event of an error, you can can specify a different error code to return.
         * 
         * @param redirect
         *        Container for redirect information. You can redirect requests to another host, to another page, or
         *        with another protocol. In the event of an error, you can can specify a different error code to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirect(Redirect redirect);

        /**
         * Container for redirect information. You can redirect requests to another host, to another page, or with
         * another protocol. In the event of an error, you can can specify a different error code to return. This is a
         * convenience that creates an instance of the {@link Redirect.Builder} avoiding the need to create one manually
         * via {@link Redirect#builder()}.
         *
         * When the {@link Consumer} completes, {@link Redirect.Builder#build()} is called immediately and its result is
         * passed to {@link #redirect(Redirect)}.
         * 
         * @param redirect
         *        a consumer that will call methods on {@link Redirect.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redirect(Redirect)
         */
        default Builder redirect(Consumer<Redirect.Builder> redirect) {
            return redirect(Redirect.builder().apply(redirect).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Condition condition;

        private Redirect redirect;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingRule model) {
            condition(model.condition);
            redirect(model.redirect);
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        public final Redirect.Builder getRedirect() {
            return redirect != null ? redirect.toBuilder() : null;
        }

        @Override
        public final Builder redirect(Redirect redirect) {
            this.redirect = redirect;
            return this;
        }

        public final void setRedirect(Redirect.BuilderImpl redirect) {
            this.redirect = redirect != null ? redirect.build() : null;
        }

        @Override
        public RoutingRule build() {
            return new RoutingRule(this);
        }
    }
}
