/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Object implements ToCopyableBuilder<S3Object.Builder, S3Object> {
    private final String key;

    private final Instant lastModified;

    private final String eTag;

    private final Long size;

    private final String storageClass;

    private final Owner owner;

    private S3Object(BuilderImpl builder) {
        this.key = builder.key;
        this.lastModified = builder.lastModified;
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public String key() {
        return key;
    }

    /**
     * Returns the value of the LastModified property for this object.
     * 
     * @return The value of the LastModified property for this object.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * Returns the value of the ETag property for this object.
     * 
     * @return The value of the ETag property for this object.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * Returns the value of the Size property for this object.
     * 
     * @return The value of the Size property for this object.
     */
    public Long size() {
        return size;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link ObjectStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see ObjectStorageClass
     */
    public ObjectStorageClass storageClass() {
        return ObjectStorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link ObjectStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see ObjectStorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(eTag(), other.eTag()) && Objects.equals(size(), other.size())
                && Objects.equals(storageClassString(), other.storageClassString()) && Objects.equals(owner(), other.owner());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (lastModified() != null) {
            sb.append("LastModified: ").append(lastModified()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (storageClassString() != null) {
            sb.append("StorageClass: ").append(storageClassString()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "LastModified":
            return Optional.of(clazz.cast(lastModified()));
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        case "Size":
            return Optional.of(clazz.cast(size()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, S3Object> {
        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the value of the LastModified property for this object.
         *
         * @param lastModified
         *        The new value for the LastModified property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * Sets the value of the ETag property for this object.
         *
         * @param eTag
         *        The new value for the ETag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * Sets the value of the Size property for this object.
         *
         * @param size
         *        The new value for the Size property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see ObjectStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see ObjectStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectStorageClass
         */
        Builder storageClass(ObjectStorageClass storageClass);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * Sets the value of the Owner property for this object.
         *
         * This is a convenience that creates an instance of the {@link Owner.Builder} avoiding the need to create one
         * manually via {@link Owner#builder()}.
         *
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().apply(owner).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private Instant lastModified;

        private String eTag;

        private Long size;

        private String storageClass;

        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Object model) {
            key(model.key);
            lastModified(model.lastModified);
            eTag(model.eTag);
            size(model.size);
            storageClass(model.storageClass);
            owner(model.owner);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public S3Object build() {
            return new S3Object(this);
        }
    }
}
