/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StorageClassAnalysisDataExport implements
        ToCopyableBuilder<StorageClassAnalysisDataExport.Builder, StorageClassAnalysisDataExport> {
    private final String outputSchemaVersion;

    private final AnalyticsExportDestination destination;

    private StorageClassAnalysisDataExport(BuilderImpl builder) {
        this.outputSchemaVersion = builder.outputSchemaVersion;
        this.destination = builder.destination;
    }

    /**
     * The version of the output schema to use when exporting data. Must be V_1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputSchemaVersion} will return {@link StorageClassAnalysisSchemaVersion#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #outputSchemaVersionString}.
     * </p>
     * 
     * @return The version of the output schema to use when exporting data. Must be V_1.
     * @see StorageClassAnalysisSchemaVersion
     */
    public StorageClassAnalysisSchemaVersion outputSchemaVersion() {
        return StorageClassAnalysisSchemaVersion.fromValue(outputSchemaVersion);
    }

    /**
     * The version of the output schema to use when exporting data. Must be V_1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputSchemaVersion} will return {@link StorageClassAnalysisSchemaVersion#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #outputSchemaVersionString}.
     * </p>
     * 
     * @return The version of the output schema to use when exporting data. Must be V_1.
     * @see StorageClassAnalysisSchemaVersion
     */
    public String outputSchemaVersionString() {
        return outputSchemaVersion;
    }

    /**
     * The place to store the data for an analysis.
     * 
     * @return The place to store the data for an analysis.
     */
    public AnalyticsExportDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputSchemaVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageClassAnalysisDataExport)) {
            return false;
        }
        StorageClassAnalysisDataExport other = (StorageClassAnalysisDataExport) obj;
        return Objects.equals(outputSchemaVersionString(), other.outputSchemaVersionString())
                && Objects.equals(destination(), other.destination());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (outputSchemaVersionString() != null) {
            sb.append("OutputSchemaVersion: ").append(outputSchemaVersionString()).append(",");
        }
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputSchemaVersion":
            return Optional.of(clazz.cast(outputSchemaVersionString()));
        case "Destination":
            return Optional.of(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StorageClassAnalysisDataExport> {
        /**
         * The version of the output schema to use when exporting data. Must be V_1.
         * 
         * @param outputSchemaVersion
         *        The version of the output schema to use when exporting data. Must be V_1.
         * @see StorageClassAnalysisSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClassAnalysisSchemaVersion
         */
        Builder outputSchemaVersion(String outputSchemaVersion);

        /**
         * The version of the output schema to use when exporting data. Must be V_1.
         * 
         * @param outputSchemaVersion
         *        The version of the output schema to use when exporting data. Must be V_1.
         * @see StorageClassAnalysisSchemaVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClassAnalysisSchemaVersion
         */
        Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion);

        /**
         * The place to store the data for an analysis.
         * 
         * @param destination
         *        The place to store the data for an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(AnalyticsExportDestination destination);

        /**
         * The place to store the data for an analysis. This is a convenience that creates an instance of the
         * {@link AnalyticsExportDestination.Builder} avoiding the need to create one manually via
         * {@link AnalyticsExportDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsExportDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #destination(AnalyticsExportDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link AnalyticsExportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(AnalyticsExportDestination)
         */
        default Builder destination(Consumer<AnalyticsExportDestination.Builder> destination) {
            return destination(AnalyticsExportDestination.builder().apply(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputSchemaVersion;

        private AnalyticsExportDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageClassAnalysisDataExport model) {
            outputSchemaVersion(model.outputSchemaVersion);
            destination(model.destination);
        }

        public final String getOutputSchemaVersion() {
            return outputSchemaVersion;
        }

        @Override
        public final Builder outputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
            return this;
        }

        @Override
        public final Builder outputSchemaVersion(StorageClassAnalysisSchemaVersion outputSchemaVersion) {
            this.outputSchemaVersion(outputSchemaVersion.toString());
            return this;
        }

        public final void setOutputSchemaVersion(String outputSchemaVersion) {
            this.outputSchemaVersion = outputSchemaVersion;
        }

        public final AnalyticsExportDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(AnalyticsExportDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(AnalyticsExportDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public StorageClassAnalysisDataExport build() {
            return new StorageClassAnalysisDataExport(this);
        }
    }
}
