/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CORSRule StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CORSRuleUnmarshaller implements Unmarshaller<CORSRule, StaxUnmarshallerContext> {

    public CORSRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        CORSRule.Builder corsRule = CORSRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> allowedHeaders = null;
        java.util.List<String> allowedMethods = null;
        java.util.List<String> allowedOrigins = null;
        java.util.List<String> exposeHeaders = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                corsRule.allowedHeaders(allowedHeaders);
                corsRule.allowedMethods(allowedMethods);
                corsRule.allowedOrigins(allowedOrigins);
                corsRule.exposeHeaders(exposeHeaders);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("AllowedHeader", targetDepth)) {
                    if (allowedHeaders == null) {
                        allowedHeaders = new ArrayList<>();
                    }
                    allowedHeaders.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AllowedMethod", targetDepth)) {
                    if (allowedMethods == null) {
                        allowedMethods = new ArrayList<>();
                    }
                    allowedMethods.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AllowedOrigin", targetDepth)) {
                    if (allowedOrigins == null) {
                        allowedOrigins = new ArrayList<>();
                    }
                    allowedOrigins.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ExposeHeader", targetDepth)) {
                    if (exposeHeaders == null) {
                        exposeHeaders = new ArrayList<>();
                    }
                    exposeHeaders.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxAgeSeconds", targetDepth)) {
                    corsRule.maxAgeSeconds(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    corsRule.allowedHeaders(allowedHeaders);
                    corsRule.allowedMethods(allowedMethods);
                    corsRule.allowedOrigins(allowedOrigins);
                    corsRule.exposeHeaders(exposeHeaders);
                    break;
                }
            }
        }
        return corsRule.build();
    }

    private static final CORSRuleUnmarshaller INSTANCE = new CORSRuleUnmarshaller();

    public static CORSRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}
