/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.MetadataCopier;
import software.amazon.awssdk.services.s3.model.MetadataDirective;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.TaggingDirective;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyObjectRequest> {
    private final String acl;
    private final String bucket;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;
    private final String copySource;
    private final String copySourceIfMatch;
    private final Instant copySourceIfModifiedSince;
    private final String copySourceIfNoneMatch;
    private final Instant copySourceIfUnmodifiedSince;
    private final Instant expires;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWriteACP;
    private final String key;
    private final Map<String, String> metadata;
    private final String metadataDirective;
    private final String taggingDirective;
    private final String serverSideEncryption;
    private final String storageClass;
    private final String websiteRedirectLocation;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String copySourceSSECustomerAlgorithm;
    private final String copySourceSSECustomerKey;
    private final String copySourceSSECustomerKeyMD5;
    private final String requestPayer;
    private final String tagging;

    private CopyObjectRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentType = builder.contentType;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.metadataDirective = builder.metadataDirective;
        this.taggingDirective = builder.taggingDirective;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.tagging = builder.tagging;
    }

    public ObjectCannedACL acl() {
        return ObjectCannedACL.fromValue(this.acl);
    }

    public String aclString() {
        return this.acl;
    }

    public String bucket() {
        return this.bucket;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public String copySource() {
        return this.copySource;
    }

    public String copySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public Instant copySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String copySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public Instant copySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public Instant expires() {
        return this.expires;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public MetadataDirective metadataDirective() {
        return MetadataDirective.fromValue(this.metadataDirective);
    }

    public String metadataDirectiveString() {
        return this.metadataDirective;
    }

    public TaggingDirective taggingDirective() {
        return TaggingDirective.fromValue(this.taggingDirective);
    }

    public String taggingDirectiveString() {
        return this.taggingDirective;
    }

    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(this.serverSideEncryption);
    }

    public String serverSideEncryptionString() {
        return this.serverSideEncryption;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassString() {
        return this.storageClass;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public String copySourceSSECustomerAlgorithm() {
        return this.copySourceSSECustomerAlgorithm;
    }

    public String copySourceSSECustomerKey() {
        return this.copySourceSSECustomerKey;
    }

    public String copySourceSSECustomerKeyMD5() {
        return this.copySourceSSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    public String tagging() {
        return this.tagging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aclString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySource());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfModifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfUnmodifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantFullControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantReadACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantWriteACP());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataDirectiveString());
        hashCode = 31 * hashCode + Objects.hashCode(this.taggingDirectiveString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteRedirectLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagging());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyObjectRequest)) {
            return false;
        }
        CopyObjectRequest other = (CopyObjectRequest)((Object)obj);
        return Objects.equals(this.aclString(), other.aclString()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentDisposition(), other.contentDisposition()) && Objects.equals(this.contentEncoding(), other.contentEncoding()) && Objects.equals(this.contentLanguage(), other.contentLanguage()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.copySource(), other.copySource()) && Objects.equals(this.copySourceIfMatch(), other.copySourceIfMatch()) && Objects.equals(this.copySourceIfModifiedSince(), other.copySourceIfModifiedSince()) && Objects.equals(this.copySourceIfNoneMatch(), other.copySourceIfNoneMatch()) && Objects.equals(this.copySourceIfUnmodifiedSince(), other.copySourceIfUnmodifiedSince()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.grantFullControl(), other.grantFullControl()) && Objects.equals(this.grantRead(), other.grantRead()) && Objects.equals(this.grantReadACP(), other.grantReadACP()) && Objects.equals(this.grantWriteACP(), other.grantWriteACP()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.metadataDirectiveString(), other.metadataDirectiveString()) && Objects.equals(this.taggingDirectiveString(), other.taggingDirectiveString()) && Objects.equals(this.serverSideEncryptionString(), other.serverSideEncryptionString()) && Objects.equals(this.storageClassString(), other.storageClassString()) && Objects.equals(this.websiteRedirectLocation(), other.websiteRedirectLocation()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKey(), other.sseCustomerKey()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.ssekmsKeyId(), other.ssekmsKeyId()) && Objects.equals(this.copySourceSSECustomerAlgorithm(), other.copySourceSSECustomerAlgorithm()) && Objects.equals(this.copySourceSSECustomerKey(), other.copySourceSSECustomerKey()) && Objects.equals(this.copySourceSSECustomerKeyMD5(), other.copySourceSSECustomerKeyMD5()) && Objects.equals(this.requestPayerString(), other.requestPayerString()) && Objects.equals(this.tagging(), other.tagging());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.aclString() != null) {
            sb.append("ACL: ").append(this.aclString()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.cacheControl() != null) {
            sb.append("CacheControl: ").append(this.cacheControl()).append(",");
        }
        if (this.contentDisposition() != null) {
            sb.append("ContentDisposition: ").append(this.contentDisposition()).append(",");
        }
        if (this.contentEncoding() != null) {
            sb.append("ContentEncoding: ").append(this.contentEncoding()).append(",");
        }
        if (this.contentLanguage() != null) {
            sb.append("ContentLanguage: ").append(this.contentLanguage()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.copySource() != null) {
            sb.append("CopySource: ").append(this.copySource()).append(",");
        }
        if (this.copySourceIfMatch() != null) {
            sb.append("CopySourceIfMatch: ").append(this.copySourceIfMatch()).append(",");
        }
        if (this.copySourceIfModifiedSince() != null) {
            sb.append("CopySourceIfModifiedSince: ").append(this.copySourceIfModifiedSince()).append(",");
        }
        if (this.copySourceIfNoneMatch() != null) {
            sb.append("CopySourceIfNoneMatch: ").append(this.copySourceIfNoneMatch()).append(",");
        }
        if (this.copySourceIfUnmodifiedSince() != null) {
            sb.append("CopySourceIfUnmodifiedSince: ").append(this.copySourceIfUnmodifiedSince()).append(",");
        }
        if (this.expires() != null) {
            sb.append("Expires: ").append(this.expires()).append(",");
        }
        if (this.grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(this.grantFullControl()).append(",");
        }
        if (this.grantRead() != null) {
            sb.append("GrantRead: ").append(this.grantRead()).append(",");
        }
        if (this.grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(this.grantReadACP()).append(",");
        }
        if (this.grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(this.grantWriteACP()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.metadataDirectiveString() != null) {
            sb.append("MetadataDirective: ").append(this.metadataDirectiveString()).append(",");
        }
        if (this.taggingDirectiveString() != null) {
            sb.append("TaggingDirective: ").append(this.taggingDirectiveString()).append(",");
        }
        if (this.serverSideEncryptionString() != null) {
            sb.append("ServerSideEncryption: ").append(this.serverSideEncryptionString()).append(",");
        }
        if (this.storageClassString() != null) {
            sb.append("StorageClass: ").append(this.storageClassString()).append(",");
        }
        if (this.websiteRedirectLocation() != null) {
            sb.append("WebsiteRedirectLocation: ").append(this.websiteRedirectLocation()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(this.sseCustomerKey()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(this.ssekmsKeyId()).append(",");
        }
        if (this.copySourceSSECustomerAlgorithm() != null) {
            sb.append("CopySourceSSECustomerAlgorithm: ").append(this.copySourceSSECustomerAlgorithm()).append(",");
        }
        if (this.copySourceSSECustomerKey() != null) {
            sb.append("CopySourceSSECustomerKey: ").append(this.copySourceSSECustomerKey()).append(",");
        }
        if (this.copySourceSSECustomerKeyMD5() != null) {
            sb.append("CopySourceSSECustomerKeyMD5: ").append(this.copySourceSSECustomerKeyMD5()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (this.tagging() != null) {
            sb.append("Tagging: ").append(this.tagging()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACL": {
                return Optional.of(clazz.cast(this.aclString()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "CacheControl": {
                return Optional.of(clazz.cast(this.cacheControl()));
            }
            case "ContentDisposition": {
                return Optional.of(clazz.cast(this.contentDisposition()));
            }
            case "ContentEncoding": {
                return Optional.of(clazz.cast(this.contentEncoding()));
            }
            case "ContentLanguage": {
                return Optional.of(clazz.cast(this.contentLanguage()));
            }
            case "ContentType": {
                return Optional.of(clazz.cast(this.contentType()));
            }
            case "CopySource": {
                return Optional.of(clazz.cast(this.copySource()));
            }
            case "CopySourceIfMatch": {
                return Optional.of(clazz.cast(this.copySourceIfMatch()));
            }
            case "CopySourceIfModifiedSince": {
                return Optional.of(clazz.cast(this.copySourceIfModifiedSince()));
            }
            case "CopySourceIfNoneMatch": {
                return Optional.of(clazz.cast(this.copySourceIfNoneMatch()));
            }
            case "CopySourceIfUnmodifiedSince": {
                return Optional.of(clazz.cast(this.copySourceIfUnmodifiedSince()));
            }
            case "Expires": {
                return Optional.of(clazz.cast(this.expires()));
            }
            case "GrantFullControl": {
                return Optional.of(clazz.cast(this.grantFullControl()));
            }
            case "GrantRead": {
                return Optional.of(clazz.cast(this.grantRead()));
            }
            case "GrantReadACP": {
                return Optional.of(clazz.cast(this.grantReadACP()));
            }
            case "GrantWriteACP": {
                return Optional.of(clazz.cast(this.grantWriteACP()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "MetadataDirective": {
                return Optional.of(clazz.cast(this.metadataDirectiveString()));
            }
            case "TaggingDirective": {
                return Optional.of(clazz.cast(this.taggingDirectiveString()));
            }
            case "ServerSideEncryption": {
                return Optional.of(clazz.cast(this.serverSideEncryptionString()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassString()));
            }
            case "WebsiteRedirectLocation": {
                return Optional.of(clazz.cast(this.websiteRedirectLocation()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKey": {
                return Optional.of(clazz.cast(this.sseCustomerKey()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "SSEKMSKeyId": {
                return Optional.of(clazz.cast(this.ssekmsKeyId()));
            }
            case "CopySourceSSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerAlgorithm()));
            }
            case "CopySourceSSECustomerKey": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerKey()));
            }
            case "CopySourceSSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerKeyMD5()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
            case "Tagging": {
                return Optional.of(clazz.cast(this.tagging()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acl;
        private String bucket;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentType;
        private String copySource;
        private String copySourceIfMatch;
        private Instant copySourceIfModifiedSince;
        private String copySourceIfNoneMatch;
        private Instant copySourceIfUnmodifiedSince;
        private Instant expires;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWriteACP;
        private String key;
        private Map<String, String> metadata;
        private String metadataDirective;
        private String taggingDirective;
        private String serverSideEncryption;
        private String storageClass;
        private String websiteRedirectLocation;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String copySourceSSECustomerAlgorithm;
        private String copySourceSSECustomerKey;
        private String copySourceSSECustomerKeyMD5;
        private String requestPayer;
        private String tagging;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyObjectRequest model) {
            this.acl(model.acl);
            this.bucket(model.bucket);
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.contentType(model.contentType);
            this.copySource(model.copySource);
            this.copySourceIfMatch(model.copySourceIfMatch);
            this.copySourceIfModifiedSince(model.copySourceIfModifiedSince);
            this.copySourceIfNoneMatch(model.copySourceIfNoneMatch);
            this.copySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            this.expires(model.expires);
            this.grantFullControl(model.grantFullControl);
            this.grantRead(model.grantRead);
            this.grantReadACP(model.grantReadACP);
            this.grantWriteACP(model.grantWriteACP);
            this.key(model.key);
            this.metadata(model.metadata);
            this.metadataDirective(model.metadataDirective);
            this.taggingDirective(model.taggingDirective);
            this.serverSideEncryption(model.serverSideEncryption);
            this.storageClass(model.storageClass);
            this.websiteRedirectLocation(model.websiteRedirectLocation);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKey(model.sseCustomerKey);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.ssekmsKeyId(model.ssekmsKeyId);
            this.copySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            this.copySourceSSECustomerKey(model.copySourceSSECustomerKey);
            this.copySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
            this.tagging(model.tagging);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCopySource() {
            return this.copySource;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        public final void setCopySource(String copySource) {
            this.copySource = copySource;
        }

        public final String getCopySourceIfMatch() {
            return this.copySourceIfMatch;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public final void setCopySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
        }

        public final Instant getCopySourceIfModifiedSince() {
            return this.copySourceIfModifiedSince;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public final void setCopySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
        }

        public final String getCopySourceIfNoneMatch() {
            return this.copySourceIfNoneMatch;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public final void setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        }

        public final Instant getCopySourceIfUnmodifiedSince() {
            return this.copySourceIfUnmodifiedSince;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public final void setCopySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getMetadataDirective() {
            return this.metadataDirective;
        }

        @Override
        public final Builder metadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        @Override
        public final Builder metadataDirective(MetadataDirective metadataDirective) {
            this.metadataDirective(metadataDirective.toString());
            return this;
        }

        public final void setMetadataDirective(String metadataDirective) {
            this.metadataDirective = metadataDirective;
        }

        public final String getTaggingDirective() {
            return this.taggingDirective;
        }

        @Override
        public final Builder taggingDirective(String taggingDirective) {
            this.taggingDirective = taggingDirective;
            return this;
        }

        @Override
        public final Builder taggingDirective(TaggingDirective taggingDirective) {
            this.taggingDirective(taggingDirective.toString());
            return this;
        }

        public final void setTaggingDirective(String taggingDirective) {
            this.taggingDirective = taggingDirective;
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public final void setWebsiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getCopySourceSSECustomerAlgorithm() {
            return this.copySourceSSECustomerAlgorithm;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        public final void setCopySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
        }

        public final String getCopySourceSSECustomerKey() {
            return this.copySourceSSECustomerKey;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        public final void setCopySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
        }

        public final String getCopySourceSSECustomerKeyMD5() {
            return this.copySourceSSECustomerKeyMD5;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        public final void setCopySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getTagging() {
            return this.tagging;
        }

        @Override
        public final Builder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        public final void setTagging(String tagging) {
            this.tagging = tagging;
        }

        public CopyObjectRequest build() {
            return new CopyObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyObjectRequest> {
        public Builder acl(String var1);

        public Builder acl(ObjectCannedACL var1);

        public Builder bucket(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentType(String var1);

        public Builder copySource(String var1);

        public Builder copySourceIfMatch(String var1);

        public Builder copySourceIfModifiedSince(Instant var1);

        public Builder copySourceIfNoneMatch(String var1);

        public Builder copySourceIfUnmodifiedSince(Instant var1);

        public Builder expires(Instant var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder metadataDirective(String var1);

        public Builder metadataDirective(MetadataDirective var1);

        public Builder taggingDirective(String var1);

        public Builder taggingDirective(TaggingDirective var1);

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder copySourceSSECustomerAlgorithm(String var1);

        public Builder copySourceSSECustomerKey(String var1);

        public Builder copySourceSSECustomerKeyMD5(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder tagging(String var1);
    }
}

