/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.model.InventoryConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketInventoryConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
    private final String continuationToken;
    private final List<InventoryConfiguration> inventoryConfigurationList;
    private final Boolean isTruncated;
    private final String nextContinuationToken;

    private ListBucketInventoryConfigurationsResponse(BuilderImpl builder) {
        this.continuationToken = builder.continuationToken;
        this.inventoryConfigurationList = builder.inventoryConfigurationList;
        this.isTruncated = builder.isTruncated;
        this.nextContinuationToken = builder.nextContinuationToken;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public List<InventoryConfiguration> inventoryConfigurationList() {
        return this.inventoryConfigurationList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryConfigurationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextContinuationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketInventoryConfigurationsResponse)) {
            return false;
        }
        ListBucketInventoryConfigurationsResponse other = (ListBucketInventoryConfigurationsResponse)((Object)obj);
        return Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.inventoryConfigurationList(), other.inventoryConfigurationList()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextContinuationToken(), other.nextContinuationToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.inventoryConfigurationList() != null) {
            sb.append("InventoryConfigurationList: ").append(this.inventoryConfigurationList()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(this.nextContinuationToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinuationToken": {
                return Optional.of(clazz.cast(this.continuationToken()));
            }
            case "InventoryConfigurationList": {
                return Optional.of(clazz.cast(this.inventoryConfigurationList()));
            }
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "NextContinuationToken": {
                return Optional.of(clazz.cast(this.nextContinuationToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String continuationToken;
        private List<InventoryConfiguration> inventoryConfigurationList;
        private Boolean isTruncated;
        private String nextContinuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketInventoryConfigurationsResponse model) {
            this.continuationToken(model.continuationToken);
            this.inventoryConfigurationList(model.inventoryConfigurationList);
            this.isTruncated(model.isTruncated);
            this.nextContinuationToken(model.nextContinuationToken);
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Collection<InventoryConfiguration.Builder> getInventoryConfigurationList() {
            return this.inventoryConfigurationList != null ? (Collection)this.inventoryConfigurationList.stream().map(InventoryConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryConfigurationList(InventoryConfiguration ... inventoryConfigurationList) {
            this.inventoryConfigurationList(Arrays.asList(inventoryConfigurationList));
            return this;
        }

        public final void setInventoryConfigurationList(Collection<InventoryConfiguration.BuilderImpl> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copyFromBuilder(inventoryConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public ListBucketInventoryConfigurationsResponse build() {
            return new ListBucketInventoryConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
        public Builder continuationToken(String var1);

        public Builder inventoryConfigurationList(Collection<InventoryConfiguration> var1);

        public Builder inventoryConfigurationList(InventoryConfiguration ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextContinuationToken(String var1);
    }
}

