/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;

public class AbortMultipartUploadRequestMarshaller
implements Marshaller<Request<AbortMultipartUploadRequest>, AbortMultipartUploadRequest> {
    public Request<AbortMultipartUploadRequest> marshall(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (abortMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)abortMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (abortMultipartUploadRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)abortMultipartUploadRequest.requestPayerString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", abortMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", abortMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        if (abortMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString((String)abortMultipartUploadRequest.uploadId()));
        }
        return request;
    }
}

