/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;

public class GetObjectAclRequestMarshaller
implements Marshaller<Request<GetObjectAclRequest>, GetObjectAclRequest> {
    public Request<GetObjectAclRequest> marshall(GetObjectAclRequest getObjectAclRequest) {
        if (getObjectAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getObjectAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectAclRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)getObjectAclRequest.requestPayerString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectAclRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)getObjectAclRequest.versionId()));
        }
        return request;
    }
}

