/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.FilterRule;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.QueueConfiguration;
import software.amazon.awssdk.services.s3.model.S3KeyFilter;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;

public class PutBucketNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketNotificationConfigurationRequest>, PutBucketNotificationConfigurationRequest> {
    public Request<PutBucketNotificationConfigurationRequest> marshall(PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {
        if (putBucketNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketNotificationConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?notification";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketNotificationConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            NotificationConfiguration notificationConfiguration = putBucketNotificationConfigurationRequest.notificationConfiguration();
            if (notificationConfiguration != null) {
                List<LambdaFunctionConfiguration> list;
                List<QueueConfiguration> notificationConfigurationQueueConfigurationsList;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");
                List<TopicConfiguration> notificationConfigurationTopicConfigurationsList = notificationConfiguration.topicConfigurations();
                if (notificationConfigurationTopicConfigurationsList != null) {
                    for (TopicConfiguration topicConfiguration : notificationConfigurationTopicConfigurationsList) {
                        NotificationConfigurationFilter filter;
                        List<String> topicConfigurationEventsList;
                        xmlWriter.startElement("TopicConfiguration");
                        if (topicConfiguration.id() != null) {
                            xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                        }
                        if (topicConfiguration.topicArn() != null) {
                            xmlWriter.startElement("Topic").value(topicConfiguration.topicArn()).endElement();
                        }
                        if ((topicConfigurationEventsList = topicConfiguration.eventsStrings()) != null) {
                            for (String topicConfigurationEventsListValue : topicConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(topicConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = topicConfiguration.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (s3KeyFilterFilterRulesList != null) {
                                    for (FilterRule filterRule : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");
                                        if (filterRule.nameString() != null) {
                                            xmlWriter.startElement("Name").value(filterRule.nameString()).endElement();
                                        }
                                        if (filterRule.value() != null) {
                                            xmlWriter.startElement("Value").value(filterRule.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if ((notificationConfigurationQueueConfigurationsList = notificationConfiguration.queueConfigurations()) != null) {
                    for (QueueConfiguration notificationConfigurationQueueConfigurationsListValue : notificationConfigurationQueueConfigurationsList) {
                        NotificationConfigurationFilter filter;
                        List<String> queueConfigurationEventsList;
                        xmlWriter.startElement("QueueConfiguration");
                        if (notificationConfigurationQueueConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationQueueConfigurationsListValue.id()).endElement();
                        }
                        if (notificationConfigurationQueueConfigurationsListValue.queueArn() != null) {
                            xmlWriter.startElement("Queue").value(notificationConfigurationQueueConfigurationsListValue.queueArn()).endElement();
                        }
                        if ((queueConfigurationEventsList = notificationConfigurationQueueConfigurationsListValue.eventsStrings()) != null) {
                            for (String queueConfigurationEventsListValue : queueConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(queueConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = notificationConfigurationQueueConfigurationsListValue.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (s3KeyFilterFilterRulesList != null) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");
                                        if (s3KeyFilterFilterRulesListValue.nameString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameString()).endElement();
                                        }
                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                if ((list = notificationConfiguration.lambdaFunctionConfigurations()) != null) {
                    for (LambdaFunctionConfiguration notificationConfigurationLambdaFunctionConfigurationsListValue : list) {
                        NotificationConfigurationFilter filter;
                        List<String> lambdaFunctionConfigurationEventsList;
                        xmlWriter.startElement("CloudFunctionConfiguration");
                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationLambdaFunctionConfigurationsListValue.id()).endElement();
                        }
                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn() != null) {
                            xmlWriter.startElement("CloudFunction").value(notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn()).endElement();
                        }
                        if ((lambdaFunctionConfigurationEventsList = notificationConfigurationLambdaFunctionConfigurationsListValue.eventsStrings()) != null) {
                            for (String lambdaFunctionConfigurationEventsListValue : lambdaFunctionConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(lambdaFunctionConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((filter = notificationConfigurationLambdaFunctionConfigurationsListValue.filter()) != null) {
                            xmlWriter.startElement("Filter");
                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");
                                List<FilterRule> list2 = key.filterRules();
                                if (list2 != null) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : list2) {
                                        xmlWriter.startElement("FilterRule");
                                        if (s3KeyFilterFilterRulesListValue.nameString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameString()).endElement();
                                        }
                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

