/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GlacierJobParameters implements ToCopyableBuilder<GlacierJobParameters.Builder, GlacierJobParameters> {
    private final String tier;

    private GlacierJobParameters(BuilderImpl builder) {
        this.tier = builder.tier;
    }

    /**
     * Glacier retrieval tier at which the restore will be processed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #tierString}.
     * </p>
     * 
     * @return Glacier retrieval tier at which the restore will be processed.
     * @see Tier
     */
    public Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * Glacier retrieval tier at which the restore will be processed.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from {@link #tierString}.
     * </p>
     * 
     * @return Glacier retrieval tier at which the restore will be processed.
     * @see Tier
     */
    public String tierString() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tierString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlacierJobParameters)) {
            return false;
        }
        GlacierJobParameters other = (GlacierJobParameters) obj;
        return Objects.equals(tierString(), other.tierString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tierString() != null) {
            sb.append("Tier: ").append(tierString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tier":
            return Optional.of(clazz.cast(tierString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GlacierJobParameters> {
        /**
         * Glacier retrieval tier at which the restore will be processed.
         * 
         * @param tier
         *        Glacier retrieval tier at which the restore will be processed.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * Glacier retrieval tier at which the restore will be processed.
         * 
         * @param tier
         *        Glacier retrieval tier at which the restore will be processed.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);
    }

    static final class BuilderImpl implements Builder {
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(GlacierJobParameters model) {
            tier(model.tier);
        }

        public final String getTier() {
            return tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public GlacierJobParameters build() {
            return new GlacierJobParameters(this);
        }
    }
}
