/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPartsResponse extends S3Response implements ToCopyableBuilder<ListPartsResponse.Builder, ListPartsResponse> {
    private final Instant abortDate;

    private final String abortRuleId;

    private final String bucket;

    private final String key;

    private final String uploadId;

    private final Integer partNumberMarker;

    private final Integer nextPartNumberMarker;

    private final Integer maxParts;

    private final Boolean isTruncated;

    private final List<Part> parts;

    private final Initiator initiator;

    private final Owner owner;

    private final String storageClass;

    private final String requestCharged;

    private ListPartsResponse(BuilderImpl builder) {
        super(builder);
        this.abortDate = builder.abortDate;
        this.abortRuleId = builder.abortRuleId;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.partNumberMarker = builder.partNumberMarker;
        this.nextPartNumberMarker = builder.nextPartNumberMarker;
        this.maxParts = builder.maxParts;
        this.isTruncated = builder.isTruncated;
        this.parts = builder.parts;
        this.initiator = builder.initiator;
        this.owner = builder.owner;
        this.storageClass = builder.storageClass;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * Date when multipart upload will become eligible for abort operation by lifecycle.
     * 
     * @return Date when multipart upload will become eligible for abort operation by lifecycle.
     */
    public Instant abortDate() {
        return abortDate;
    }

    /**
     * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     * 
     * @return Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     */
    public String abortRuleId() {
        return abortRuleId;
    }

    /**
     * Name of the bucket to which the multipart upload was initiated.
     * 
     * @return Name of the bucket to which the multipart upload was initiated.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Object key for which the multipart upload was initiated.
     * 
     * @return Object key for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * Upload ID identifying the multipart upload whose parts are being listed.
     * 
     * @return Upload ID identifying the multipart upload whose parts are being listed.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Part number after which listing begins.
     * 
     * @return Part number after which listing begins.
     */
    public Integer partNumberMarker() {
        return partNumberMarker;
    }

    /**
     * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the
     * part-number-marker request parameter in a subsequent request.
     * 
     * @return When a list is truncated, this element specifies the last part in the list, as well as the value to use
     *         for the part-number-marker request parameter in a subsequent request.
     */
    public Integer nextPartNumberMarker() {
        return nextPartNumberMarker;
    }

    /**
     * Maximum number of parts that were allowed in the response.
     * 
     * @return Maximum number of parts that were allowed in the response.
     */
    public Integer maxParts() {
        return maxParts;
    }

    /**
     * Indicates whether the returned list of parts is truncated.
     * 
     * @return Indicates whether the returned list of parts is truncated.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * Returns the value of the Parts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Parts property for this object.
     */
    public List<Part> parts() {
        return parts;
    }

    /**
     * Identifies who initiated the multipart upload.
     * 
     * @return Identifies who initiated the multipart upload.
     */
    public Initiator initiator() {
        return initiator;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(requestCharged);
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestChargedString() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(abortDate());
        hashCode = 31 * hashCode + Objects.hashCode(abortRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(partNumberMarker());
        hashCode = 31 * hashCode + Objects.hashCode(nextPartNumberMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxParts());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(parts());
        hashCode = 31 * hashCode + Objects.hashCode(initiator());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassString());
        hashCode = 31 * hashCode + Objects.hashCode(requestChargedString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse) obj;
        return Objects.equals(abortDate(), other.abortDate()) && Objects.equals(abortRuleId(), other.abortRuleId())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(uploadId(), other.uploadId()) && Objects.equals(partNumberMarker(), other.partNumberMarker())
                && Objects.equals(nextPartNumberMarker(), other.nextPartNumberMarker())
                && Objects.equals(maxParts(), other.maxParts()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(parts(), other.parts()) && Objects.equals(initiator(), other.initiator())
                && Objects.equals(owner(), other.owner()) && Objects.equals(storageClassString(), other.storageClassString())
                && Objects.equals(requestChargedString(), other.requestChargedString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (abortDate() != null) {
            sb.append("AbortDate: ").append(abortDate()).append(",");
        }
        if (abortRuleId() != null) {
            sb.append("AbortRuleId: ").append(abortRuleId()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(partNumberMarker()).append(",");
        }
        if (nextPartNumberMarker() != null) {
            sb.append("NextPartNumberMarker: ").append(nextPartNumberMarker()).append(",");
        }
        if (maxParts() != null) {
            sb.append("MaxParts: ").append(maxParts()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (parts() != null) {
            sb.append("Parts: ").append(parts()).append(",");
        }
        if (initiator() != null) {
            sb.append("Initiator: ").append(initiator()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (storageClassString() != null) {
            sb.append("StorageClass: ").append(storageClassString()).append(",");
        }
        if (requestChargedString() != null) {
            sb.append("RequestCharged: ").append(requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbortDate":
            return Optional.of(clazz.cast(abortDate()));
        case "AbortRuleId":
            return Optional.of(clazz.cast(abortRuleId()));
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "UploadId":
            return Optional.of(clazz.cast(uploadId()));
        case "PartNumberMarker":
            return Optional.of(clazz.cast(partNumberMarker()));
        case "NextPartNumberMarker":
            return Optional.of(clazz.cast(nextPartNumberMarker()));
        case "MaxParts":
            return Optional.of(clazz.cast(maxParts()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "Parts":
            return Optional.of(clazz.cast(parts()));
        case "Initiator":
            return Optional.of(clazz.cast(initiator()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        case "RequestCharged":
            return Optional.of(clazz.cast(requestChargedString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, ListPartsResponse> {
        /**
         * Date when multipart upload will become eligible for abort operation by lifecycle.
         * 
         * @param abortDate
         *        Date when multipart upload will become eligible for abort operation by lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortDate(Instant abortDate);

        /**
         * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * 
         * @param abortRuleId
         *        Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortRuleId(String abortRuleId);

        /**
         * Name of the bucket to which the multipart upload was initiated.
         * 
         * @param bucket
         *        Name of the bucket to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Object key for which the multipart upload was initiated.
         * 
         * @param key
         *        Object key for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Upload ID identifying the multipart upload whose parts are being listed.
         * 
         * @param uploadId
         *        Upload ID identifying the multipart upload whose parts are being listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Part number after which listing begins.
         * 
         * @param partNumberMarker
         *        Part number after which listing begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumberMarker(Integer partNumberMarker);

        /**
         * When a list is truncated, this element specifies the last part in the list, as well as the value to use for
         * the part-number-marker request parameter in a subsequent request.
         * 
         * @param nextPartNumberMarker
         *        When a list is truncated, this element specifies the last part in the list, as well as the value to
         *        use for the part-number-marker request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPartNumberMarker(Integer nextPartNumberMarker);

        /**
         * Maximum number of parts that were allowed in the response.
         * 
         * @param maxParts
         *        Maximum number of parts that were allowed in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParts(Integer maxParts);

        /**
         * Indicates whether the returned list of parts is truncated.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of parts is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<Part> parts);

        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Part... parts);

        /**
         * Identifies who initiated the multipart upload.
         * 
         * @param initiator
         *        Identifies who initiated the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiator(Initiator initiator);

        /**
         * Identifies who initiated the multipart upload. This is a convenience that creates an instance of the
         * {@link Initiator.Builder} avoiding the need to create one manually via {@link Initiator#builder()}.
         *
         * When the {@link Consumer} completes, {@link Initiator.Builder#build()} is called immediately and its result
         * is passed to {@link #initiator(Initiator)}.
         * 
         * @param initiator
         *        a consumer that will call methods on {@link Initiator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiator(Initiator)
         */
        default Builder initiator(Consumer<Initiator.Builder> initiator) {
            return initiator(Initiator.builder().apply(initiator).build());
        }

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * Sets the value of the Owner property for this object.
         *
         * This is a convenience that creates an instance of the {@link Owner.Builder} avoiding the need to create one
         * manually via {@link Owner#builder()}.
         *
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().apply(owner).build());
        }

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private Instant abortDate;

        private String abortRuleId;

        private String bucket;

        private String key;

        private String uploadId;

        private Integer partNumberMarker;

        private Integer nextPartNumberMarker;

        private Integer maxParts;

        private Boolean isTruncated;

        private List<Part> parts;

        private Initiator initiator;

        private Owner owner;

        private String storageClass;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            abortDate(model.abortDate);
            abortRuleId(model.abortRuleId);
            bucket(model.bucket);
            key(model.key);
            uploadId(model.uploadId);
            partNumberMarker(model.partNumberMarker);
            nextPartNumberMarker(model.nextPartNumberMarker);
            maxParts(model.maxParts);
            isTruncated(model.isTruncated);
            parts(model.parts);
            initiator(model.initiator);
            owner(model.owner);
            storageClass(model.storageClass);
            requestCharged(model.requestCharged);
        }

        public final Instant getAbortDate() {
            return abortDate;
        }

        @Override
        public final Builder abortDate(Instant abortDate) {
            this.abortDate = abortDate;
            return this;
        }

        public final void setAbortDate(Instant abortDate) {
            this.abortDate = abortDate;
        }

        public final String getAbortRuleId() {
            return abortRuleId;
        }

        @Override
        public final Builder abortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
            return this;
        }

        public final void setAbortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Integer getPartNumberMarker() {
            return partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final Integer getNextPartNumberMarker() {
            return nextPartNumberMarker;
        }

        @Override
        public final Builder nextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            return this;
        }

        public final void setNextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
        }

        public final Integer getMaxParts() {
            return maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<Part.Builder> getParts() {
            return parts != null ? parts.stream().map(Part::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parts(Collection<Part> parts) {
            this.parts = PartsCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Part... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        public final void setParts(Collection<Part.BuilderImpl> parts) {
            this.parts = PartsCopier.copyFromBuilder(parts);
        }

        public final Initiator.Builder getInitiator() {
            return initiator != null ? initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }
    }
}
