/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Redirect implements ToCopyableBuilder<Redirect.Builder, Redirect> {
    private final String hostName;

    private final String httpRedirectCode;

    private final String protocol;

    private final String replaceKeyPrefixWith;

    private final String replaceKeyWith;

    private Redirect(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.httpRedirectCode = builder.httpRedirectCode;
        this.protocol = builder.protocol;
        this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
        this.replaceKeyWith = builder.replaceKeyWith;
    }

    /**
     * The host name to use in the redirect request.
     * 
     * @return The host name to use in the redirect request.
     */
    public String hostName() {
        return hostName;
    }

    /**
     * The HTTP redirect code to use on the response. Not required if one of the siblings is present.
     * 
     * @return The HTTP redirect code to use on the response. Not required if one of the siblings is present.
     */
    public String httpRedirectCode() {
        return httpRedirectCode;
    }

    /**
     * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the original
     * request.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
     *         original request.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the original
     * request.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
     *         original request.
     * @see Protocol
     */
    public String protocolString() {
        return protocol;
    }

    /**
     * The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix
     * docs/ (objects in the docs/ folder) to documents/, you can set a condition block with KeyPrefixEquals set to
     * docs/ and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required if one of the siblings is present.
     * Can be present only if ReplaceKeyWith is not provided.
     * 
     * @return The object key prefix to use in the redirect request. For example, to redirect requests for all pages
     *         with prefix docs/ (objects in the docs/ folder) to documents/, you can set a condition block with
     *         KeyPrefixEquals set to docs/ and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required if
     *         one of the siblings is present. Can be present only if ReplaceKeyWith is not provided.
     */
    public String replaceKeyPrefixWith() {
        return replaceKeyPrefixWith;
    }

    /**
     * The specific object key to use in the redirect request. For example, redirect request to error.html. Not required
     * if one of the sibling is present. Can be present only if ReplaceKeyPrefixWith is not provided.
     * 
     * @return The specific object key to use in the redirect request. For example, redirect request to error.html. Not
     *         required if one of the sibling is present. Can be present only if ReplaceKeyPrefixWith is not provided.
     */
    public String replaceKeyWith() {
        return replaceKeyWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(httpRedirectCode());
        hashCode = 31 * hashCode + Objects.hashCode(protocolString());
        hashCode = 31 * hashCode + Objects.hashCode(replaceKeyPrefixWith());
        hashCode = 31 * hashCode + Objects.hashCode(replaceKeyWith());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Redirect)) {
            return false;
        }
        Redirect other = (Redirect) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(httpRedirectCode(), other.httpRedirectCode())
                && Objects.equals(protocolString(), other.protocolString())
                && Objects.equals(replaceKeyPrefixWith(), other.replaceKeyPrefixWith())
                && Objects.equals(replaceKeyWith(), other.replaceKeyWith());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (hostName() != null) {
            sb.append("HostName: ").append(hostName()).append(",");
        }
        if (httpRedirectCode() != null) {
            sb.append("HttpRedirectCode: ").append(httpRedirectCode()).append(",");
        }
        if (protocolString() != null) {
            sb.append("Protocol: ").append(protocolString()).append(",");
        }
        if (replaceKeyPrefixWith() != null) {
            sb.append("ReplaceKeyPrefixWith: ").append(replaceKeyPrefixWith()).append(",");
        }
        if (replaceKeyWith() != null) {
            sb.append("ReplaceKeyWith: ").append(replaceKeyWith()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostName":
            return Optional.of(clazz.cast(hostName()));
        case "HttpRedirectCode":
            return Optional.of(clazz.cast(httpRedirectCode()));
        case "Protocol":
            return Optional.of(clazz.cast(protocolString()));
        case "ReplaceKeyPrefixWith":
            return Optional.of(clazz.cast(replaceKeyPrefixWith()));
        case "ReplaceKeyWith":
            return Optional.of(clazz.cast(replaceKeyWith()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Redirect> {
        /**
         * The host name to use in the redirect request.
         * 
         * @param hostName
         *        The host name to use in the redirect request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * The HTTP redirect code to use on the response. Not required if one of the siblings is present.
         * 
         * @param httpRedirectCode
         *        The HTTP redirect code to use on the response. Not required if one of the siblings is present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRedirectCode(String httpRedirectCode);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The object key prefix to use in the redirect request. For example, to redirect requests for all pages with
         * prefix docs/ (objects in the docs/ folder) to documents/, you can set a condition block with KeyPrefixEquals
         * set to docs/ and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required if one of the siblings
         * is present. Can be present only if ReplaceKeyWith is not provided.
         * 
         * @param replaceKeyPrefixWith
         *        The object key prefix to use in the redirect request. For example, to redirect requests for all pages
         *        with prefix docs/ (objects in the docs/ folder) to documents/, you can set a condition block with
         *        KeyPrefixEquals set to docs/ and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
         *        if one of the siblings is present. Can be present only if ReplaceKeyWith is not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceKeyPrefixWith(String replaceKeyPrefixWith);

        /**
         * The specific object key to use in the redirect request. For example, redirect request to error.html. Not
         * required if one of the sibling is present. Can be present only if ReplaceKeyPrefixWith is not provided.
         * 
         * @param replaceKeyWith
         *        The specific object key to use in the redirect request. For example, redirect request to error.html.
         *        Not required if one of the sibling is present. Can be present only if ReplaceKeyPrefixWith is not
         *        provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceKeyWith(String replaceKeyWith);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String httpRedirectCode;

        private String protocol;

        private String replaceKeyPrefixWith;

        private String replaceKeyWith;

        private BuilderImpl() {
        }

        private BuilderImpl(Redirect model) {
            hostName(model.hostName);
            httpRedirectCode(model.httpRedirectCode);
            protocol(model.protocol);
            replaceKeyPrefixWith(model.replaceKeyPrefixWith);
            replaceKeyWith(model.replaceKeyWith);
        }

        public final String getHostName() {
            return hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getHttpRedirectCode() {
            return httpRedirectCode;
        }

        @Override
        public final Builder httpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        public final void setHttpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getReplaceKeyPrefixWith() {
            return replaceKeyPrefixWith;
        }

        @Override
        public final Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
            return this;
        }

        public final void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        public final String getReplaceKeyWith() {
            return replaceKeyWith;
        }

        @Override
        public final Builder replaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
            return this;
        }

        public final void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        @Override
        public Redirect build() {
            return new Redirect(this);
        }
    }
}
