/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class VersioningConfiguration implements ToCopyableBuilder<VersioningConfiguration.Builder, VersioningConfiguration> {
    private final String mfaDelete;

    private final String status;

    private VersioningConfiguration(BuilderImpl builder) {
        this.mfaDelete = builder.mfaDelete;
        this.status = builder.status;
    }

    /**
     * Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if
     * the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not
     * returned.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaDelete} will
     * return {@link MFADelete#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mfaDeleteString}.
     * </p>
     * 
     * @return Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only
     *         returned if the bucket has been configured with MFA delete. If the bucket has never been so configured,
     *         this element is not returned.
     * @see MFADelete
     */
    public MFADelete mfaDelete() {
        return MFADelete.fromValue(mfaDelete);
    }

    /**
     * Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned if
     * the bucket has been configured with MFA delete. If the bucket has never been so configured, this element is not
     * returned.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mfaDelete} will
     * return {@link MFADelete#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mfaDeleteString}.
     * </p>
     * 
     * @return Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only
     *         returned if the bucket has been configured with MFA delete. If the bucket has never been so configured,
     *         this element is not returned.
     * @see MFADelete
     */
    public String mfaDeleteString() {
        return mfaDelete;
    }

    /**
     * The versioning state of the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BucketVersioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The versioning state of the bucket.
     * @see BucketVersioningStatus
     */
    public BucketVersioningStatus status() {
        return BucketVersioningStatus.fromValue(status);
    }

    /**
     * The versioning state of the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BucketVersioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The versioning state of the bucket.
     * @see BucketVersioningStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mfaDeleteString());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersioningConfiguration)) {
            return false;
        }
        VersioningConfiguration other = (VersioningConfiguration) obj;
        return Objects.equals(mfaDeleteString(), other.mfaDeleteString()) && Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (mfaDeleteString() != null) {
            sb.append("MFADelete: ").append(mfaDeleteString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MFADelete":
            return Optional.of(clazz.cast(mfaDeleteString()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VersioningConfiguration> {
        /**
         * Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned
         * if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element
         * is not returned.
         * 
         * @param mfaDelete
         *        Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only
         *        returned if the bucket has been configured with MFA delete. If the bucket has never been so
         *        configured, this element is not returned.
         * @see MFADelete
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MFADelete
         */
        Builder mfaDelete(String mfaDelete);

        /**
         * Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only returned
         * if the bucket has been configured with MFA delete. If the bucket has never been so configured, this element
         * is not returned.
         * 
         * @param mfaDelete
         *        Specifies whether MFA delete is enabled in the bucket versioning configuration. This element is only
         *        returned if the bucket has been configured with MFA delete. If the bucket has never been so
         *        configured, this element is not returned.
         * @see MFADelete
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MFADelete
         */
        Builder mfaDelete(MFADelete mfaDelete);

        /**
         * The versioning state of the bucket.
         * 
         * @param status
         *        The versioning state of the bucket.
         * @see BucketVersioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketVersioningStatus
         */
        Builder status(String status);

        /**
         * The versioning state of the bucket.
         * 
         * @param status
         *        The versioning state of the bucket.
         * @see BucketVersioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketVersioningStatus
         */
        Builder status(BucketVersioningStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String mfaDelete;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VersioningConfiguration model) {
            mfaDelete(model.mfaDelete);
            status(model.status);
        }

        public final String getMFADelete() {
            return mfaDelete;
        }

        @Override
        public final Builder mfaDelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
            return this;
        }

        @Override
        public final Builder mfaDelete(MFADelete mfaDelete) {
            this.mfaDelete(mfaDelete.toString());
            return this;
        }

        public final void setMFADelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BucketVersioningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public VersioningConfiguration build() {
            return new VersioningConfiguration(this);
        }
    }
}
