/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LoggingEnabled StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LoggingEnabledUnmarshaller implements Unmarshaller<LoggingEnabled, StaxUnmarshallerContext> {

    public LoggingEnabled unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoggingEnabled.Builder loggingEnabled = LoggingEnabled.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<TargetGrant> targetGrants = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                loggingEnabled.targetGrants(targetGrants);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("TargetBucket", targetDepth)) {
                    loggingEnabled.targetBucket(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TargetGrants", targetDepth)) {
                    targetGrants = new ArrayList<TargetGrant>();
                    continue;
                }

                if (context.testExpression("TargetGrants/Grant", targetDepth)) {
                    targetGrants.add(TargetGrantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("TargetPrefix", targetDepth)) {
                    loggingEnabled.targetPrefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    loggingEnabled.targetGrants(targetGrants);
                    break;
                }
            }
        }
        return loggingEnabled.build();
    }

    private static final LoggingEnabledUnmarshaller INSTANCE = new LoggingEnabledUnmarshaller();

    public static LoggingEnabledUnmarshaller getInstance() {
        return INSTANCE;
    }
}
