/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;

import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.XmlWriter;

/**
 * PutBucketNotificationConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketNotificationConfigurationRequestMarshaller implements
        Marshaller<Request<PutBucketNotificationConfigurationRequest>, PutBucketNotificationConfigurationRequest> {

    public Request<PutBucketNotificationConfigurationRequest> marshall(
            PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {

        if (putBucketNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketNotificationConfigurationRequest> request = new DefaultRequest<PutBucketNotificationConfigurationRequest>(
                putBucketNotificationConfigurationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        String uriResourcePath = "/{Bucket}?notification";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketNotificationConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            NotificationConfiguration notificationConfiguration = putBucketNotificationConfigurationRequest
                    .notificationConfiguration();
            if (notificationConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");

                java.util.List<TopicConfiguration> notificationConfigurationTopicConfigurationsList = notificationConfiguration
                        .topicConfigurations();
                if (notificationConfigurationTopicConfigurationsList != null) {
                    for (TopicConfiguration notificationConfigurationTopicConfigurationsListValue : notificationConfigurationTopicConfigurationsList) {
                        xmlWriter.startElement("TopicConfiguration");

                        if (notificationConfigurationTopicConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationTopicConfigurationsListValue.id())
                                    .endElement();
                        }

                        if (notificationConfigurationTopicConfigurationsListValue.topicArn() != null) {
                            xmlWriter.startElement("Topic")
                                    .value(notificationConfigurationTopicConfigurationsListValue.topicArn()).endElement();
                        }

                        java.util.List<String> topicConfigurationEventsList = notificationConfigurationTopicConfigurationsListValue
                                .eventsStrings();
                        if (topicConfigurationEventsList != null) {
                            for (String topicConfigurationEventsListValue : topicConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(topicConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationTopicConfigurationsListValue.filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (s3KeyFilterFilterRulesList != null) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }

                java.util.List<QueueConfiguration> notificationConfigurationQueueConfigurationsList = notificationConfiguration
                        .queueConfigurations();
                if (notificationConfigurationQueueConfigurationsList != null) {
                    for (QueueConfiguration notificationConfigurationQueueConfigurationsListValue : notificationConfigurationQueueConfigurationsList) {
                        xmlWriter.startElement("QueueConfiguration");

                        if (notificationConfigurationQueueConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id").value(notificationConfigurationQueueConfigurationsListValue.id())
                                    .endElement();
                        }

                        if (notificationConfigurationQueueConfigurationsListValue.queueArn() != null) {
                            xmlWriter.startElement("Queue")
                                    .value(notificationConfigurationQueueConfigurationsListValue.queueArn()).endElement();
                        }

                        java.util.List<String> queueConfigurationEventsList = notificationConfigurationQueueConfigurationsListValue
                                .eventsStrings();
                        if (queueConfigurationEventsList != null) {
                            for (String queueConfigurationEventsListValue : queueConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(queueConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationQueueConfigurationsListValue.filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (s3KeyFilterFilterRulesList != null) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }

                java.util.List<LambdaFunctionConfiguration> notificationConfigurationLambdaFunctionConfigurationsList = notificationConfiguration
                        .lambdaFunctionConfigurations();
                if (notificationConfigurationLambdaFunctionConfigurationsList != null) {
                    for (LambdaFunctionConfiguration notificationConfigurationLambdaFunctionConfigurationsListValue : notificationConfigurationLambdaFunctionConfigurationsList) {
                        xmlWriter.startElement("CloudFunctionConfiguration");

                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.id() != null) {
                            xmlWriter.startElement("Id")
                                    .value(notificationConfigurationLambdaFunctionConfigurationsListValue.id()).endElement();
                        }

                        if (notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn() != null) {
                            xmlWriter.startElement("CloudFunction")
                                    .value(notificationConfigurationLambdaFunctionConfigurationsListValue.lambdaFunctionArn())
                                    .endElement();
                        }

                        java.util.List<String> lambdaFunctionConfigurationEventsList = notificationConfigurationLambdaFunctionConfigurationsListValue
                                .eventsStrings();
                        if (lambdaFunctionConfigurationEventsList != null) {
                            for (String lambdaFunctionConfigurationEventsListValue : lambdaFunctionConfigurationEventsList) {
                                xmlWriter.startElement("Event");
                                xmlWriter.value(lambdaFunctionConfigurationEventsListValue);
                                xmlWriter.endElement();
                            }
                        }

                        NotificationConfigurationFilter filter = notificationConfigurationLambdaFunctionConfigurationsListValue
                                .filter();
                        if (filter != null) {
                            xmlWriter.startElement("Filter");

                            S3KeyFilter key = filter.key();
                            if (key != null) {
                                xmlWriter.startElement("S3Key");

                                java.util.List<FilterRule> s3KeyFilterFilterRulesList = key.filterRules();
                                if (s3KeyFilterFilterRulesList != null) {
                                    for (FilterRule s3KeyFilterFilterRulesListValue : s3KeyFilterFilterRulesList) {
                                        xmlWriter.startElement("FilterRule");

                                        if (s3KeyFilterFilterRulesListValue.nameString() != null) {
                                            xmlWriter.startElement("Name").value(s3KeyFilterFilterRulesListValue.nameString())
                                                    .endElement();
                                        }

                                        if (s3KeyFilterFilterRulesListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(s3KeyFilterFilterRulesListValue.value())
                                                    .endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}