/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.XmlWriter;

/**
 * PutBucketNotificationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketNotificationRequestMarshaller implements
        Marshaller<Request<PutBucketNotificationRequest>, PutBucketNotificationRequest> {

    public Request<PutBucketNotificationRequest> marshall(PutBucketNotificationRequest putBucketNotificationRequest) {

        if (putBucketNotificationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketNotificationRequest> request = new DefaultRequest<PutBucketNotificationRequest>(
                putBucketNotificationRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketNotificationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketNotificationRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?notification";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketNotificationRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            NotificationConfigurationDeprecated notificationConfiguration = putBucketNotificationRequest
                    .notificationConfiguration();
            if (notificationConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("NotificationConfiguration");

                TopicConfigurationDeprecated topicConfiguration = notificationConfiguration.topicConfiguration();
                if (topicConfiguration != null) {
                    xmlWriter.startElement("TopicConfiguration");

                    if (topicConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(topicConfiguration.id()).endElement();
                    }

                    java.util.List<String> topicConfigurationDeprecatedEventsList = topicConfiguration.eventsStrings();
                    if (topicConfigurationDeprecatedEventsList != null) {
                        for (String topicConfigurationDeprecatedEventsListValue : topicConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(topicConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (topicConfiguration.eventString() != null) {
                        xmlWriter.startElement("Event").value(topicConfiguration.eventString()).endElement();
                    }

                    if (topicConfiguration.topic() != null) {
                        xmlWriter.startElement("Topic").value(topicConfiguration.topic()).endElement();
                    }
                    xmlWriter.endElement();
                }

                QueueConfigurationDeprecated queueConfiguration = notificationConfiguration.queueConfiguration();
                if (queueConfiguration != null) {
                    xmlWriter.startElement("QueueConfiguration");

                    if (queueConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(queueConfiguration.id()).endElement();
                    }

                    if (queueConfiguration.eventString() != null) {
                        xmlWriter.startElement("Event").value(queueConfiguration.eventString()).endElement();
                    }

                    java.util.List<String> queueConfigurationDeprecatedEventsList = queueConfiguration.eventsStrings();
                    if (queueConfigurationDeprecatedEventsList != null) {
                        for (String queueConfigurationDeprecatedEventsListValue : queueConfigurationDeprecatedEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(queueConfigurationDeprecatedEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (queueConfiguration.queue() != null) {
                        xmlWriter.startElement("Queue").value(queueConfiguration.queue()).endElement();
                    }
                    xmlWriter.endElement();
                }

                CloudFunctionConfiguration cloudFunctionConfiguration = notificationConfiguration.cloudFunctionConfiguration();
                if (cloudFunctionConfiguration != null) {
                    xmlWriter.startElement("CloudFunctionConfiguration");

                    if (cloudFunctionConfiguration.id() != null) {
                        xmlWriter.startElement("Id").value(cloudFunctionConfiguration.id()).endElement();
                    }

                    if (cloudFunctionConfiguration.eventString() != null) {
                        xmlWriter.startElement("Event").value(cloudFunctionConfiguration.eventString()).endElement();
                    }

                    java.util.List<String> cloudFunctionConfigurationEventsList = cloudFunctionConfiguration.eventsStrings();
                    if (cloudFunctionConfigurationEventsList != null) {
                        for (String cloudFunctionConfigurationEventsListValue : cloudFunctionConfigurationEventsList) {
                            xmlWriter.startElement("Event");
                            xmlWriter.value(cloudFunctionConfigurationEventsListValue);
                            xmlWriter.endElement();
                        }
                    }

                    if (cloudFunctionConfiguration.cloudFunction() != null) {
                        xmlWriter.startElement("CloudFunction").value(cloudFunctionConfiguration.cloudFunction()).endElement();
                    }

                    if (cloudFunctionConfiguration.invocationRole() != null) {
                        xmlWriter.startElement("InvocationRole").value(cloudFunctionConfiguration.invocationRole()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}