/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.transform.GrantUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class AccessControlPolicyUnmarshaller
implements Unmarshaller<AccessControlPolicy, StaxUnmarshallerContext> {
    private static final AccessControlPolicyUnmarshaller INSTANCE = new AccessControlPolicyUnmarshaller();

    public AccessControlPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccessControlPolicy.Builder accessControlPolicy;
        block6: {
            accessControlPolicy = AccessControlPolicy.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Grant> grants = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    accessControlPolicy.grants(grants);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AccessControlList", targetDepth)) {
                        grants = new ArrayList<Grant>();
                        continue;
                    }
                    if (context.testExpression("AccessControlList/Grant", targetDepth)) {
                        grants.add(GrantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Owner", targetDepth)) continue;
                    accessControlPolicy.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            accessControlPolicy.grants(grants);
        }
        return (AccessControlPolicy)accessControlPolicy.build();
    }

    public static AccessControlPolicyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

