/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3;

import java.nio.file.Path;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseBytes;
import software.amazon.awssdk.core.sync.ResponseInputStream;
import software.amazon.awssdk.core.sync.StreamingResponseHandler;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.ObjectNotInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;
import software.amazon.awssdk.services.s3.paginators.ListPartsIterable;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing Amazon S3. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface S3Client extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "s3";

    /**
     * Create a {@link S3Client} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static S3Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link S3Client}.
     */
    static S3ClientBuilder builder() {
        return new DefaultS3ClientBuilder();
    }

    /**
     * <p>
     * Aborts a multipart upload.
     * </p>
     * <p>
     * To verify that all parts have been removed, so you don't get charged for the part storage, you should call the
     * List Parts operation and ensure the parts list is empty.
     * </p>
     *
     * @param abortMultipartUploadRequest
     * @return Result of the AbortMultipartUpload operation returned by the service.
     * @throws NoSuchUploadException
     *         The specified multipart upload does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.AbortMultipartUpload
     */
    default AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest)
            throws NoSuchUploadException, SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Aborts a multipart upload.
     * </p>
     * <p>
     * To verify that all parts have been removed, so you don't get charged for the part storage, you should call the
     * List Parts operation and ensure the parts list is empty.
     * </p>
     *
     * @param abortMultipartUploadRequest
     * @return Result of the AbortMultipartUpload operation returned by the service.
     * @throws NoSuchUploadException
     *         The specified multipart upload does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.AbortMultipartUpload
     */
    default AbortMultipartUploadResponse abortMultipartUpload(
            Consumer<AbortMultipartUploadRequest.Builder> abortMultipartUploadRequest) throws NoSuchUploadException,
            SdkServiceException, SdkClientException, S3Exception {
        return abortMultipartUpload(AbortMultipartUploadRequest.builder().apply(abortMultipartUploadRequest).build());
    }

    /**
     * Completes a multipart upload by assembling previously uploaded parts.
     *
     * @param completeMultipartUploadRequest
     * @return Result of the CompleteMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CompleteMultipartUpload
     */
    default CompleteMultipartUploadResponse completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Completes a multipart upload by assembling previously uploaded parts.
     *
     * @param completeMultipartUploadRequest
     * @return Result of the CompleteMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CompleteMultipartUpload
     */
    default CompleteMultipartUploadResponse completeMultipartUpload(
            Consumer<CompleteMultipartUploadRequest.Builder> completeMultipartUploadRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return completeMultipartUpload(CompleteMultipartUploadRequest.builder().apply(completeMultipartUploadRequest).build());
    }

    /**
     * Creates a copy of an object that is already stored in Amazon S3.
     *
     * @param copyObjectRequest
     * @return Result of the CopyObject operation returned by the service.
     * @throws ObjectNotInActiveTierErrorException
     *         The source object of the COPY operation is not in the active tier and is only stored in Amazon Glacier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CopyObject
     */
    default CopyObjectResponse copyObject(CopyObjectRequest copyObjectRequest) throws ObjectNotInActiveTierErrorException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a copy of an object that is already stored in Amazon S3.
     *
     * @param copyObjectRequest
     * @return Result of the CopyObject operation returned by the service.
     * @throws ObjectNotInActiveTierErrorException
     *         The source object of the COPY operation is not in the active tier and is only stored in Amazon Glacier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CopyObject
     */
    default CopyObjectResponse copyObject(Consumer<CopyObjectRequest.Builder> copyObjectRequest)
            throws ObjectNotInActiveTierErrorException, SdkServiceException, SdkClientException, S3Exception {
        return copyObject(CopyObjectRequest.builder().apply(copyObjectRequest).build());
    }

    /**
     * Creates a new bucket.
     *
     * @param createBucketRequest
     * @return Result of the CreateBucket operation returned by the service.
     * @throws BucketAlreadyExistsException
     *         The requested bucket name is not available. The bucket namespace is shared by all users of the system.
     *         Please select a different name and try again.
     * @throws BucketAlreadyOwnedByYouException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateBucket
     */
    default CreateBucketResponse createBucket(CreateBucketRequest createBucketRequest) throws BucketAlreadyExistsException,
            BucketAlreadyOwnedByYouException, SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new bucket.
     *
     * @param createBucketRequest
     * @return Result of the CreateBucket operation returned by the service.
     * @throws BucketAlreadyExistsException
     *         The requested bucket name is not available. The bucket namespace is shared by all users of the system.
     *         Please select a different name and try again.
     * @throws BucketAlreadyOwnedByYouException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateBucket
     */
    default CreateBucketResponse createBucket(Consumer<CreateBucketRequest.Builder> createBucketRequest)
            throws BucketAlreadyExistsException, BucketAlreadyOwnedByYouException, SdkServiceException, SdkClientException,
            S3Exception {
        return createBucket(CreateBucketRequest.builder().apply(createBucketRequest).build());
    }

    /**
     * <p>
     * Initiates a multipart upload and returns an upload ID.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param createMultipartUploadRequest
     * @return Result of the CreateMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateMultipartUpload
     */
    default CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest createMultipartUploadRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a multipart upload and returns an upload ID.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param createMultipartUploadRequest
     * @return Result of the CreateMultipartUpload operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.CreateMultipartUpload
     */
    default CreateMultipartUploadResponse createMultipartUpload(
            Consumer<CreateMultipartUploadRequest.Builder> createMultipartUploadRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return createMultipartUpload(CreateMultipartUploadRequest.builder().apply(createMultipartUploadRequest).build());
    }

    /**
     * Deletes the bucket. All objects (including all object versions and Delete Markers) in the bucket must be deleted
     * before the bucket itself can be deleted.
     *
     * @param deleteBucketRequest
     * @return Result of the DeleteBucket operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucket
     */
    default DeleteBucketResponse deleteBucket(DeleteBucketRequest deleteBucketRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the bucket. All objects (including all object versions and Delete Markers) in the bucket must be deleted
     * before the bucket itself can be deleted.
     *
     * @param deleteBucketRequest
     * @return Result of the DeleteBucket operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucket
     */
    default DeleteBucketResponse deleteBucket(Consumer<DeleteBucketRequest.Builder> deleteBucketRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucket(DeleteBucketRequest.builder().apply(deleteBucketRequest).build());
    }

    /**
     * Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param deleteBucketAnalyticsConfigurationRequest
     * @return Result of the DeleteBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketAnalyticsConfiguration
     */
    default DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(
            DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param deleteBucketAnalyticsConfigurationRequest
     * @return Result of the DeleteBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketAnalyticsConfiguration
     */
    default DeleteBucketAnalyticsConfigurationResponse deleteBucketAnalyticsConfiguration(
            Consumer<DeleteBucketAnalyticsConfigurationRequest.Builder> deleteBucketAnalyticsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest.builder()
                .apply(deleteBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * Deletes the cors configuration information set for the bucket.
     *
     * @param deleteBucketCorsRequest
     * @return Result of the DeleteBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketCors
     */
    default DeleteBucketCorsResponse deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the cors configuration information set for the bucket.
     *
     * @param deleteBucketCorsRequest
     * @return Result of the DeleteBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketCors
     */
    default DeleteBucketCorsResponse deleteBucketCors(Consumer<DeleteBucketCorsRequest.Builder> deleteBucketCorsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucketCors(DeleteBucketCorsRequest.builder().apply(deleteBucketCorsRequest).build());
    }

    /**
     * Deletes an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param deleteBucketInventoryConfigurationRequest
     * @return Result of the DeleteBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketInventoryConfiguration
     */
    default DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(
            DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param deleteBucketInventoryConfigurationRequest
     * @return Result of the DeleteBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketInventoryConfiguration
     */
    default DeleteBucketInventoryConfigurationResponse deleteBucketInventoryConfiguration(
            Consumer<DeleteBucketInventoryConfigurationRequest.Builder> deleteBucketInventoryConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest.builder()
                .apply(deleteBucketInventoryConfigurationRequest).build());
    }

    /**
     * Deletes the lifecycle configuration from the bucket.
     *
     * @param deleteBucketLifecycleRequest
     * @return Result of the DeleteBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketLifecycle
     */
    default DeleteBucketLifecycleResponse deleteBucketLifecycle(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the lifecycle configuration from the bucket.
     *
     * @param deleteBucketLifecycleRequest
     * @return Result of the DeleteBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketLifecycle
     */
    default DeleteBucketLifecycleResponse deleteBucketLifecycle(
            Consumer<DeleteBucketLifecycleRequest.Builder> deleteBucketLifecycleRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return deleteBucketLifecycle(DeleteBucketLifecycleRequest.builder().apply(deleteBucketLifecycleRequest).build());
    }

    /**
     * Deletes a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param deleteBucketMetricsConfigurationRequest
     * @return Result of the DeleteBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketMetricsConfiguration
     */
    default DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(
            DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param deleteBucketMetricsConfigurationRequest
     * @return Result of the DeleteBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketMetricsConfiguration
     */
    default DeleteBucketMetricsConfigurationResponse deleteBucketMetricsConfiguration(
            Consumer<DeleteBucketMetricsConfigurationRequest.Builder> deleteBucketMetricsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest.builder()
                .apply(deleteBucketMetricsConfigurationRequest).build());
    }

    /**
     * Deletes the policy from the bucket.
     *
     * @param deleteBucketPolicyRequest
     * @return Result of the DeleteBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketPolicy
     */
    default DeleteBucketPolicyResponse deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the policy from the bucket.
     *
     * @param deleteBucketPolicyRequest
     * @return Result of the DeleteBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketPolicy
     */
    default DeleteBucketPolicyResponse deleteBucketPolicy(Consumer<DeleteBucketPolicyRequest.Builder> deleteBucketPolicyRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteBucketPolicy(DeleteBucketPolicyRequest.builder().apply(deleteBucketPolicyRequest).build());
    }

    /**
     * Deletes the replication configuration from the bucket.
     *
     * @param deleteBucketReplicationRequest
     * @return Result of the DeleteBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketReplication
     */
    default DeleteBucketReplicationResponse deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the replication configuration from the bucket.
     *
     * @param deleteBucketReplicationRequest
     * @return Result of the DeleteBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketReplication
     */
    default DeleteBucketReplicationResponse deleteBucketReplication(
            Consumer<DeleteBucketReplicationRequest.Builder> deleteBucketReplicationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return deleteBucketReplication(DeleteBucketReplicationRequest.builder().apply(deleteBucketReplicationRequest).build());
    }

    /**
     * Deletes the tags from the bucket.
     *
     * @param deleteBucketTaggingRequest
     * @return Result of the DeleteBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketTagging
     */
    default DeleteBucketTaggingResponse deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the tags from the bucket.
     *
     * @param deleteBucketTaggingRequest
     * @return Result of the DeleteBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketTagging
     */
    default DeleteBucketTaggingResponse deleteBucketTagging(
            Consumer<DeleteBucketTaggingRequest.Builder> deleteBucketTaggingRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return deleteBucketTagging(DeleteBucketTaggingRequest.builder().apply(deleteBucketTaggingRequest).build());
    }

    /**
     * This operation removes the website configuration from the bucket.
     *
     * @param deleteBucketWebsiteRequest
     * @return Result of the DeleteBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketWebsite
     */
    default DeleteBucketWebsiteResponse deleteBucketWebsite(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * This operation removes the website configuration from the bucket.
     *
     * @param deleteBucketWebsiteRequest
     * @return Result of the DeleteBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteBucketWebsite
     */
    default DeleteBucketWebsiteResponse deleteBucketWebsite(
            Consumer<DeleteBucketWebsiteRequest.Builder> deleteBucketWebsiteRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return deleteBucketWebsite(DeleteBucketWebsiteRequest.builder().apply(deleteBucketWebsiteRequest).build());
    }

    /**
     * Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest
     * version of the object. If there isn't a null version, Amazon S3 does not remove any objects.
     *
     * @param deleteObjectRequest
     * @return Result of the DeleteObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObject
     */
    default DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest
     * version of the object. If there isn't a null version, Amazon S3 does not remove any objects.
     *
     * @param deleteObjectRequest
     * @return Result of the DeleteObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObject
     */
    default DeleteObjectResponse deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteObject(DeleteObjectRequest.builder().apply(deleteObjectRequest).build());
    }

    /**
     * Removes the tag-set from an existing object.
     *
     * @param deleteObjectTaggingRequest
     * @return Result of the DeleteObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjectTagging
     */
    default DeleteObjectTaggingResponse deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes the tag-set from an existing object.
     *
     * @param deleteObjectTaggingRequest
     * @return Result of the DeleteObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjectTagging
     */
    default DeleteObjectTaggingResponse deleteObjectTagging(
            Consumer<DeleteObjectTaggingRequest.Builder> deleteObjectTaggingRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return deleteObjectTagging(DeleteObjectTaggingRequest.builder().apply(deleteObjectTaggingRequest).build());
    }

    /**
     * This operation enables you to delete multiple objects from a bucket using a single HTTP request. You may specify
     * up to 1000 keys.
     *
     * @param deleteObjectsRequest
     * @return Result of the DeleteObjects operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjects
     */
    default DeleteObjectsResponse deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * This operation enables you to delete multiple objects from a bucket using a single HTTP request. You may specify
     * up to 1000 keys.
     *
     * @param deleteObjectsRequest
     * @return Result of the DeleteObjects operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.DeleteObjects
     */
    default DeleteObjectsResponse deleteObjects(Consumer<DeleteObjectsRequest.Builder> deleteObjectsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return deleteObjects(DeleteObjectsRequest.builder().apply(deleteObjectsRequest).build());
    }

    /**
     * Returns the accelerate configuration of a bucket.
     *
     * @param getBucketAccelerateConfigurationRequest
     * @return Result of the GetBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAccelerateConfiguration
     */
    default GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(
            GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the accelerate configuration of a bucket.
     *
     * @param getBucketAccelerateConfigurationRequest
     * @return Result of the GetBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAccelerateConfiguration
     */
    default GetBucketAccelerateConfigurationResponse getBucketAccelerateConfiguration(
            Consumer<GetBucketAccelerateConfigurationRequest.Builder> getBucketAccelerateConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest.builder()
                .apply(getBucketAccelerateConfigurationRequest).build());
    }

    /**
     * Gets the access control policy for the bucket.
     *
     * @param getBucketAclRequest
     * @return Result of the GetBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAcl
     */
    default GetBucketAclResponse getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the access control policy for the bucket.
     *
     * @param getBucketAclRequest
     * @return Result of the GetBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAcl
     */
    default GetBucketAclResponse getBucketAcl(Consumer<GetBucketAclRequest.Builder> getBucketAclRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketAcl(GetBucketAclRequest.builder().apply(getBucketAclRequest).build());
    }

    /**
     * Gets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param getBucketAnalyticsConfigurationRequest
     * @return Result of the GetBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAnalyticsConfiguration
     */
    default GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(
            GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param getBucketAnalyticsConfigurationRequest
     * @return Result of the GetBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketAnalyticsConfiguration
     */
    default GetBucketAnalyticsConfigurationResponse getBucketAnalyticsConfiguration(
            Consumer<GetBucketAnalyticsConfigurationRequest.Builder> getBucketAnalyticsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest.builder()
                .apply(getBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * Returns the cors configuration for the bucket.
     *
     * @param getBucketCorsRequest
     * @return Result of the GetBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketCors
     */
    default GetBucketCorsResponse getBucketCors(GetBucketCorsRequest getBucketCorsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the cors configuration for the bucket.
     *
     * @param getBucketCorsRequest
     * @return Result of the GetBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketCors
     */
    default GetBucketCorsResponse getBucketCors(Consumer<GetBucketCorsRequest.Builder> getBucketCorsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketCors(GetBucketCorsRequest.builder().apply(getBucketCorsRequest).build());
    }

    /**
     * Returns an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param getBucketInventoryConfigurationRequest
     * @return Result of the GetBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketInventoryConfiguration
     */
    default GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(
            GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param getBucketInventoryConfigurationRequest
     * @return Result of the GetBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketInventoryConfiguration
     */
    default GetBucketInventoryConfigurationResponse getBucketInventoryConfiguration(
            Consumer<GetBucketInventoryConfigurationRequest.Builder> getBucketInventoryConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest.builder()
                .apply(getBucketInventoryConfigurationRequest).build());
    }

    /**
     * Deprecated, see the GetBucketLifecycleConfiguration operation.
     *
     * @param getBucketLifecycleRequest
     * @return Result of the GetBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycle
     */
    default GetBucketLifecycleResponse getBucketLifecycle(GetBucketLifecycleRequest getBucketLifecycleRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deprecated, see the GetBucketLifecycleConfiguration operation.
     *
     * @param getBucketLifecycleRequest
     * @return Result of the GetBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycle
     */
    default GetBucketLifecycleResponse getBucketLifecycle(Consumer<GetBucketLifecycleRequest.Builder> getBucketLifecycleRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketLifecycle(GetBucketLifecycleRequest.builder().apply(getBucketLifecycleRequest).build());
    }

    /**
     * Returns the lifecycle configuration information set on the bucket.
     *
     * @param getBucketLifecycleConfigurationRequest
     * @return Result of the GetBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycleConfiguration
     */
    default GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(
            GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the lifecycle configuration information set on the bucket.
     *
     * @param getBucketLifecycleConfigurationRequest
     * @return Result of the GetBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLifecycleConfiguration
     */
    default GetBucketLifecycleConfigurationResponse getBucketLifecycleConfiguration(
            Consumer<GetBucketLifecycleConfigurationRequest.Builder> getBucketLifecycleConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest.builder()
                .apply(getBucketLifecycleConfigurationRequest).build());
    }

    /**
     * Returns the region the bucket resides in.
     *
     * @param getBucketLocationRequest
     * @return Result of the GetBucketLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLocation
     */
    default GetBucketLocationResponse getBucketLocation(GetBucketLocationRequest getBucketLocationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the region the bucket resides in.
     *
     * @param getBucketLocationRequest
     * @return Result of the GetBucketLocation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLocation
     */
    default GetBucketLocationResponse getBucketLocation(Consumer<GetBucketLocationRequest.Builder> getBucketLocationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketLocation(GetBucketLocationRequest.builder().apply(getBucketLocationRequest).build());
    }

    /**
     * Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET,
     * you must be the bucket owner.
     *
     * @param getBucketLoggingRequest
     * @return Result of the GetBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLogging
     */
    default GetBucketLoggingResponse getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET,
     * you must be the bucket owner.
     *
     * @param getBucketLoggingRequest
     * @return Result of the GetBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketLogging
     */
    default GetBucketLoggingResponse getBucketLogging(Consumer<GetBucketLoggingRequest.Builder> getBucketLoggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketLogging(GetBucketLoggingRequest.builder().apply(getBucketLoggingRequest).build());
    }

    /**
     * Gets a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param getBucketMetricsConfigurationRequest
     * @return Result of the GetBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketMetricsConfiguration
     */
    default GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(
            GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets a metrics configuration (specified by the metrics configuration ID) from the bucket.
     *
     * @param getBucketMetricsConfigurationRequest
     * @return Result of the GetBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketMetricsConfiguration
     */
    default GetBucketMetricsConfigurationResponse getBucketMetricsConfiguration(
            Consumer<GetBucketMetricsConfigurationRequest.Builder> getBucketMetricsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest.builder()
                .apply(getBucketMetricsConfigurationRequest).build());
    }

    /**
     * Deprecated, see the GetBucketNotificationConfiguration operation.
     *
     * @param getBucketNotificationRequest
     * @return Result of the GetBucketNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotification
     */
    default GetBucketNotificationResponse getBucketNotification(GetBucketNotificationRequest getBucketNotificationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deprecated, see the GetBucketNotificationConfiguration operation.
     *
     * @param getBucketNotificationRequest
     * @return Result of the GetBucketNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotification
     */
    default GetBucketNotificationResponse getBucketNotification(
            Consumer<GetBucketNotificationRequest.Builder> getBucketNotificationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return getBucketNotification(GetBucketNotificationRequest.builder().apply(getBucketNotificationRequest).build());
    }

    /**
     * Returns the notification configuration of a bucket.
     *
     * @param getBucketNotificationConfigurationRequest
     * @return Result of the GetBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotificationConfiguration
     */
    default GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(
            GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the notification configuration of a bucket.
     *
     * @param getBucketNotificationConfigurationRequest
     * @return Result of the GetBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketNotificationConfiguration
     */
    default GetBucketNotificationConfigurationResponse getBucketNotificationConfiguration(
            Consumer<GetBucketNotificationConfigurationRequest.Builder> getBucketNotificationConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest.builder()
                .apply(getBucketNotificationConfigurationRequest).build());
    }

    /**
     * Returns the policy of a specified bucket.
     *
     * @param getBucketPolicyRequest
     * @return Result of the GetBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicy
     */
    default GetBucketPolicyResponse getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the policy of a specified bucket.
     *
     * @param getBucketPolicyRequest
     * @return Result of the GetBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketPolicy
     */
    default GetBucketPolicyResponse getBucketPolicy(Consumer<GetBucketPolicyRequest.Builder> getBucketPolicyRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketPolicy(GetBucketPolicyRequest.builder().apply(getBucketPolicyRequest).build());
    }

    /**
     * Returns the replication configuration of a bucket.
     *
     * @param getBucketReplicationRequest
     * @return Result of the GetBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketReplication
     */
    default GetBucketReplicationResponse getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the replication configuration of a bucket.
     *
     * @param getBucketReplicationRequest
     * @return Result of the GetBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketReplication
     */
    default GetBucketReplicationResponse getBucketReplication(
            Consumer<GetBucketReplicationRequest.Builder> getBucketReplicationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return getBucketReplication(GetBucketReplicationRequest.builder().apply(getBucketReplicationRequest).build());
    }

    /**
     * Returns the request payment configuration of a bucket.
     *
     * @param getBucketRequestPaymentRequest
     * @return Result of the GetBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketRequestPayment
     */
    default GetBucketRequestPaymentResponse getBucketRequestPayment(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the request payment configuration of a bucket.
     *
     * @param getBucketRequestPaymentRequest
     * @return Result of the GetBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketRequestPayment
     */
    default GetBucketRequestPaymentResponse getBucketRequestPayment(
            Consumer<GetBucketRequestPaymentRequest.Builder> getBucketRequestPaymentRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return getBucketRequestPayment(GetBucketRequestPaymentRequest.builder().apply(getBucketRequestPaymentRequest).build());
    }

    /**
     * Returns the tag set associated with the bucket.
     *
     * @param getBucketTaggingRequest
     * @return Result of the GetBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketTagging
     */
    default GetBucketTaggingResponse getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the tag set associated with the bucket.
     *
     * @param getBucketTaggingRequest
     * @return Result of the GetBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketTagging
     */
    default GetBucketTaggingResponse getBucketTagging(Consumer<GetBucketTaggingRequest.Builder> getBucketTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketTagging(GetBucketTaggingRequest.builder().apply(getBucketTaggingRequest).build());
    }

    /**
     * Returns the versioning state of a bucket.
     *
     * @param getBucketVersioningRequest
     * @return Result of the GetBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketVersioning
     */
    default GetBucketVersioningResponse getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the versioning state of a bucket.
     *
     * @param getBucketVersioningRequest
     * @return Result of the GetBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketVersioning
     */
    default GetBucketVersioningResponse getBucketVersioning(
            Consumer<GetBucketVersioningRequest.Builder> getBucketVersioningRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return getBucketVersioning(GetBucketVersioningRequest.builder().apply(getBucketVersioningRequest).build());
    }

    /**
     * Returns the website configuration for a bucket.
     *
     * @param getBucketWebsiteRequest
     * @return Result of the GetBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketWebsite
     */
    default GetBucketWebsiteResponse getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the website configuration for a bucket.
     *
     * @param getBucketWebsiteRequest
     * @return Result of the GetBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetBucketWebsite
     */
    default GetBucketWebsiteResponse getBucketWebsite(Consumer<GetBucketWebsiteRequest.Builder> getBucketWebsiteRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getBucketWebsite(GetBucketWebsiteRequest.builder().apply(getBucketWebsiteRequest).build());
    }

    /**
     * Retrieves objects from Amazon S3.
     *
     * @param getObjectRequest
     * @param streamingHandler
     *        Functional interface for processing the streamed response content. The unmarshalled GetObjectResponse and
     *        an InputStream to the response content are provided as parameters to the callback. The callback may return
     *        a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.StreamingResponseHandler} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows 'Object data.'.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     */
    default <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest,
            StreamingResponseHandler<GetObjectResponse, ReturnT> streamingResponseHandler) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves objects from Amazon S3.
     *
     * @param getObjectRequest
     * @param path
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows 'Object data.'.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(GetObjectRequest, StreamingResponseHandler)
     */
    default GetObjectResponse getObject(GetObjectRequest getObjectRequest, Path filePath) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, StreamingResponseHandler.toFile(filePath));
    }

    /**
     * Retrieves objects from Amazon S3.
     *
     * @param getObjectRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         'Object data.'.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, StreamingResponseHandler)
     */
    default ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest getObjectRequest) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, StreamingResponseHandler.toInputStream());
    }

    /**
     * Retrieves objects from Amazon S3.
     *
     * @param getObjectRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows 'Object data.'.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObject
     * @see #getObject(getObject, StreamingResponseHandler)
     */
    default ResponseBytes<GetObjectResponse> getObjectBytes(GetObjectRequest getObjectRequest) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        return getObject(getObjectRequest, StreamingResponseHandler.toBytes());
    }

    /**
     * Returns the access control list (ACL) of an object.
     *
     * @param getObjectAclRequest
     * @return Result of the GetObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAcl
     */
    default GetObjectAclResponse getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the access control list (ACL) of an object.
     *
     * @param getObjectAclRequest
     * @return Result of the GetObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectAcl
     */
    default GetObjectAclResponse getObjectAcl(Consumer<GetObjectAclRequest.Builder> getObjectAclRequest)
            throws NoSuchKeyException, SdkServiceException, SdkClientException, S3Exception {
        return getObjectAcl(GetObjectAclRequest.builder().apply(getObjectAclRequest).build());
    }

    /**
     * Returns the tag-set of an object.
     *
     * @param getObjectTaggingRequest
     * @return Result of the GetObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTagging
     */
    default GetObjectTaggingResponse getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the tag-set of an object.
     *
     * @param getObjectTaggingRequest
     * @return Result of the GetObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTagging
     */
    default GetObjectTaggingResponse getObjectTagging(Consumer<GetObjectTaggingRequest.Builder> getObjectTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getObjectTagging(GetObjectTaggingRequest.builder().apply(getObjectTaggingRequest).build());
    }

    /**
     * Return torrent files from a bucket.
     *
     * @param getObjectTorrentRequest
     * @param streamingHandler
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        GetObjectTorrentResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.StreamingResponseHandler} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows ''.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     */
    default <ReturnT> ReturnT getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest,
            StreamingResponseHandler<GetObjectTorrentResponse, ReturnT> streamingResponseHandler) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Return torrent files from a bucket.
     *
     * @param getObjectTorrentRequest
     * @param path
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return The transformed result of the StreamingResponseHandler.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObjectTorrent(GetObjectTorrentRequest, StreamingResponseHandler)
     */
    default GetObjectTorrentResponse getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest, Path filePath)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, StreamingResponseHandler.toFile(filePath));
    }

    /**
     * Return torrent files from a bucket.
     *
     * @param getObjectTorrentRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, StreamingResponseHandler)
     */
    default ResponseInputStream<GetObjectTorrentResponse> getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, StreamingResponseHandler.toInputStream());
    }

    /**
     * Return torrent files from a bucket.
     *
     * @param getObjectTorrentRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.GetObjectTorrent
     * @see #getObject(getObjectTorrent, StreamingResponseHandler)
     */
    default ResponseBytes<GetObjectTorrentResponse> getObjectTorrentBytes(GetObjectTorrentRequest getObjectTorrentRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return getObjectTorrent(getObjectTorrentRequest, StreamingResponseHandler.toBytes());
    }

    /**
     * This operation is useful to determine if a bucket exists and you have permission to access it.
     *
     * @param headBucketRequest
     * @return Result of the HeadBucket operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadBucket
     */
    default HeadBucketResponse headBucket(HeadBucketRequest headBucketRequest) throws NoSuchBucketException, SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * This operation is useful to determine if a bucket exists and you have permission to access it.
     *
     * @param headBucketRequest
     * @return Result of the HeadBucket operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadBucket
     */
    default HeadBucketResponse headBucket(Consumer<HeadBucketRequest.Builder> headBucketRequest) throws NoSuchBucketException,
            SdkServiceException, SdkClientException, S3Exception {
        return headBucket(HeadBucketRequest.builder().apply(headBucketRequest).build());
    }

    /**
     * The HEAD operation retrieves metadata from an object without returning the object itself. This operation is
     * useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.
     *
     * @param headObjectRequest
     * @return Result of the HeadObject operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadObject
     */
    default HeadObjectResponse headObject(HeadObjectRequest headObjectRequest) throws NoSuchKeyException, SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * The HEAD operation retrieves metadata from an object without returning the object itself. This operation is
     * useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.
     *
     * @param headObjectRequest
     * @return Result of the HeadObject operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.HeadObject
     */
    default HeadObjectResponse headObject(Consumer<HeadObjectRequest.Builder> headObjectRequest) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        return headObject(HeadObjectRequest.builder().apply(headObjectRequest).build());
    }

    /**
     * Lists the analytics configurations for the bucket.
     *
     * @param listBucketAnalyticsConfigurationsRequest
     * @return Result of the ListBucketAnalyticsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketAnalyticsConfigurations
     */
    default ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(
            ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the analytics configurations for the bucket.
     *
     * @param listBucketAnalyticsConfigurationsRequest
     * @return Result of the ListBucketAnalyticsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketAnalyticsConfigurations
     */
    default ListBucketAnalyticsConfigurationsResponse listBucketAnalyticsConfigurations(
            Consumer<ListBucketAnalyticsConfigurationsRequest.Builder> listBucketAnalyticsConfigurationsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest.builder()
                .apply(listBucketAnalyticsConfigurationsRequest).build());
    }

    /**
     * Returns a list of inventory configurations for the bucket.
     *
     * @param listBucketInventoryConfigurationsRequest
     * @return Result of the ListBucketInventoryConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketInventoryConfigurations
     */
    default ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(
            ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of inventory configurations for the bucket.
     *
     * @param listBucketInventoryConfigurationsRequest
     * @return Result of the ListBucketInventoryConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketInventoryConfigurations
     */
    default ListBucketInventoryConfigurationsResponse listBucketInventoryConfigurations(
            Consumer<ListBucketInventoryConfigurationsRequest.Builder> listBucketInventoryConfigurationsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest.builder()
                .apply(listBucketInventoryConfigurationsRequest).build());
    }

    /**
     * Lists the metrics configurations for the bucket.
     *
     * @param listBucketMetricsConfigurationsRequest
     * @return Result of the ListBucketMetricsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketMetricsConfigurations
     */
    default ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(
            ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the metrics configurations for the bucket.
     *
     * @param listBucketMetricsConfigurationsRequest
     * @return Result of the ListBucketMetricsConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBucketMetricsConfigurations
     */
    default ListBucketMetricsConfigurationsResponse listBucketMetricsConfigurations(
            Consumer<ListBucketMetricsConfigurationsRequest.Builder> listBucketMetricsConfigurationsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest.builder()
                .apply(listBucketMetricsConfigurationsRequest).build());
    }

    /**
     * Returns a list of all buckets owned by the authenticated sender of the request.
     *
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     * @see #listBuckets(ListBucketsRequest)
     */
    default ListBucketsResponse listBuckets() throws SdkServiceException, SdkClientException, S3Exception {
        return listBuckets(ListBucketsRequest.builder().build());
    }

    /**
     * Returns a list of all buckets owned by the authenticated sender of the request.
     *
     * @param listBucketsRequest
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsResponse listBuckets(ListBucketsRequest listBucketsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of all buckets owned by the authenticated sender of the request.
     *
     * @param listBucketsRequest
     * @return Result of the ListBuckets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListBuckets
     */
    default ListBucketsResponse listBuckets(Consumer<ListBucketsRequest.Builder> listBucketsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return listBuckets(ListBucketsRequest.builder().apply(listBucketsRequest).build());
    }

    /**
     * This operation lists in-progress multipart uploads.
     *
     * @param listMultipartUploadsRequest
     * @return Result of the ListMultipartUploads operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * This operation lists in-progress multipart uploads.
     *
     * @param listMultipartUploadsRequest
     * @return Result of the ListMultipartUploads operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsResponse listMultipartUploads(
            Consumer<ListMultipartUploadsRequest.Builder> listMultipartUploadsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return listMultipartUploads(ListMultipartUploadsRequest.builder().apply(listMultipartUploadsRequest).build());
    }

    /**
     * This operation lists in-progress multipart uploads.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client
     *             .listMultipartUploadsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsIterable responses = client.listMultipartUploadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartUploads(software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultipartUploadsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListMultipartUploads
     */
    default ListMultipartUploadsIterable listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns metadata about all of the versions of objects in a bucket.
     *
     * @param listObjectVersionsRequest
     * @return Result of the ListObjectVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsResponse listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns metadata about all of the versions of objects in a bucket.
     *
     * @param listObjectVersionsRequest
     * @return Result of the ListObjectVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsResponse listObjectVersions(Consumer<ListObjectVersionsRequest.Builder> listObjectVersionsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return listObjectVersions(ListObjectVersionsRequest.builder().apply(listObjectVersionsRequest).build());
    }

    /**
     * Returns metadata about all of the versions of objects in a bucket.<br/>
     * <p>
     * This is a variant of
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client
     *             .listObjectVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectVersionsIterable responses = client.listObjectVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectVersions(software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listObjectVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectVersions
     */
    default ListObjectVersionsIterable listObjectVersionsPaginator(ListObjectVersionsRequest listObjectVersionsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket.
     *
     * @param listObjectsRequest
     * @return Result of the ListObjects operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjects
     */
    default ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws NoSuchBucketException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket.
     *
     * @param listObjectsRequest
     * @return Result of the ListObjects operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjects
     */
    default ListObjectsResponse listObjects(Consumer<ListObjectsRequest.Builder> listObjectsRequest)
            throws NoSuchBucketException, SdkServiceException, SdkClientException, S3Exception {
        return listObjects(ListObjectsRequest.builder().apply(listObjectsRequest).build());
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. Note: ListObjectsV2 is the revised List Objects API and
     * we recommend you use this revised API for new application development.
     *
     * @param listObjectsV2Request
     * @return Result of the ListObjectsV2 operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Response listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. Note: ListObjectsV2 is the revised List Objects API and
     * we recommend you use this revised API for new application development.
     *
     * @param listObjectsV2Request
     * @return Result of the ListObjectsV2 operation returned by the service.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Response listObjectsV2(Consumer<ListObjectsV2Request.Builder> listObjectsV2Request)
            throws NoSuchBucketException, SdkServiceException, SdkClientException, S3Exception {
        return listObjectsV2(ListObjectsV2Request.builder().apply(listObjectsV2Request).build());
    }

    /**
     * Returns some or all (up to 1000) of the objects in a bucket. You can use the request parameters as selection
     * criteria to return a subset of the objects in a bucket. Note: ListObjectsV2 is the revised List Objects API and
     * we recommend you use this revised API for new application development.<br/>
     * <p>
     * This is a variant of {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListObjectsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable responses = client.listObjectsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listObjectsV2(software.amazon.awssdk.services.s3.model.ListObjectsV2Request)} operation.</b>
     * </p>
     *
     * @param listObjectsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchBucketException
     *         The specified bucket does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListObjectsV2
     */
    default ListObjectsV2Iterable listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) throws NoSuchBucketException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the parts that have been uploaded for a specific multipart upload.
     *
     * @param listPartsRequest
     * @return Result of the ListParts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsResponse listParts(ListPartsRequest listPartsRequest) throws SdkServiceException, SdkClientException,
            S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists the parts that have been uploaded for a specific multipart upload.
     *
     * @param listPartsRequest
     * @return Result of the ListParts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsResponse listParts(Consumer<ListPartsRequest.Builder> listPartsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return listParts(ListPartsRequest.builder().apply(listPartsRequest).build());
    }

    /**
     * Lists the parts that have been uploaded for a specific multipart upload.<br/>
     * <p>
     * This is a variant of {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     *     for (software.amazon.awssdk.services.s3.model.ListPartsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.s3.paginators.ListPartsIterable responses = client.listPartsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParts(software.amazon.awssdk.services.s3.model.ListPartsRequest)} operation.</b>
     * </p>
     *
     * @param listPartsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.ListParts
     */
    default ListPartsIterable listPartsPaginator(ListPartsRequest listPartsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the accelerate configuration of an existing bucket.
     *
     * @param putBucketAccelerateConfigurationRequest
     * @return Result of the PutBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAccelerateConfiguration
     */
    default PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(
            PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the accelerate configuration of an existing bucket.
     *
     * @param putBucketAccelerateConfigurationRequest
     * @return Result of the PutBucketAccelerateConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAccelerateConfiguration
     */
    default PutBucketAccelerateConfigurationResponse putBucketAccelerateConfiguration(
            Consumer<PutBucketAccelerateConfigurationRequest.Builder> putBucketAccelerateConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketAccelerateConfiguration(PutBucketAccelerateConfigurationRequest.builder()
                .apply(putBucketAccelerateConfigurationRequest).build());
    }

    /**
     * Sets the permissions on a bucket using access control lists (ACL).
     *
     * @param putBucketAclRequest
     * @return Result of the PutBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAcl
     */
    default PutBucketAclResponse putBucketAcl(PutBucketAclRequest putBucketAclRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the permissions on a bucket using access control lists (ACL).
     *
     * @param putBucketAclRequest
     * @return Result of the PutBucketAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAcl
     */
    default PutBucketAclResponse putBucketAcl(Consumer<PutBucketAclRequest.Builder> putBucketAclRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketAcl(PutBucketAclRequest.builder().apply(putBucketAclRequest).build());
    }

    /**
     * Sets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param putBucketAnalyticsConfigurationRequest
     * @return Result of the PutBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAnalyticsConfiguration
     */
    default PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(
            PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets an analytics configuration for the bucket (specified by the analytics configuration ID).
     *
     * @param putBucketAnalyticsConfigurationRequest
     * @return Result of the PutBucketAnalyticsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketAnalyticsConfiguration
     */
    default PutBucketAnalyticsConfigurationResponse putBucketAnalyticsConfiguration(
            Consumer<PutBucketAnalyticsConfigurationRequest.Builder> putBucketAnalyticsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketAnalyticsConfiguration(PutBucketAnalyticsConfigurationRequest.builder()
                .apply(putBucketAnalyticsConfigurationRequest).build());
    }

    /**
     * Sets the cors configuration for a bucket.
     *
     * @param putBucketCorsRequest
     * @return Result of the PutBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketCors
     */
    default PutBucketCorsResponse putBucketCors(PutBucketCorsRequest putBucketCorsRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the cors configuration for a bucket.
     *
     * @param putBucketCorsRequest
     * @return Result of the PutBucketCors operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketCors
     */
    default PutBucketCorsResponse putBucketCors(Consumer<PutBucketCorsRequest.Builder> putBucketCorsRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketCors(PutBucketCorsRequest.builder().apply(putBucketCorsRequest).build());
    }

    /**
     * Adds an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param putBucketInventoryConfigurationRequest
     * @return Result of the PutBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketInventoryConfiguration
     */
    default PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(
            PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Adds an inventory configuration (identified by the inventory ID) from the bucket.
     *
     * @param putBucketInventoryConfigurationRequest
     * @return Result of the PutBucketInventoryConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketInventoryConfiguration
     */
    default PutBucketInventoryConfigurationResponse putBucketInventoryConfiguration(
            Consumer<PutBucketInventoryConfigurationRequest.Builder> putBucketInventoryConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketInventoryConfiguration(PutBucketInventoryConfigurationRequest.builder()
                .apply(putBucketInventoryConfigurationRequest).build());
    }

    /**
     * Deprecated, see the PutBucketLifecycleConfiguration operation.
     *
     * @param putBucketLifecycleRequest
     * @return Result of the PutBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycle
     */
    default PutBucketLifecycleResponse putBucketLifecycle(PutBucketLifecycleRequest putBucketLifecycleRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deprecated, see the PutBucketLifecycleConfiguration operation.
     *
     * @param putBucketLifecycleRequest
     * @return Result of the PutBucketLifecycle operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycle
     */
    default PutBucketLifecycleResponse putBucketLifecycle(Consumer<PutBucketLifecycleRequest.Builder> putBucketLifecycleRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketLifecycle(PutBucketLifecycleRequest.builder().apply(putBucketLifecycleRequest).build());
    }

    /**
     * Sets lifecycle configuration for your bucket. If a lifecycle configuration exists, it replaces it.
     *
     * @param putBucketLifecycleConfigurationRequest
     * @return Result of the PutBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycleConfiguration
     */
    default PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(
            PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets lifecycle configuration for your bucket. If a lifecycle configuration exists, it replaces it.
     *
     * @param putBucketLifecycleConfigurationRequest
     * @return Result of the PutBucketLifecycleConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLifecycleConfiguration
     */
    default PutBucketLifecycleConfigurationResponse putBucketLifecycleConfiguration(
            Consumer<PutBucketLifecycleConfigurationRequest.Builder> putBucketLifecycleConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest.builder()
                .apply(putBucketLifecycleConfigurationRequest).build());
    }

    /**
     * Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging
     * parameters. To set the logging status of a bucket, you must be the bucket owner.
     *
     * @param putBucketLoggingRequest
     * @return Result of the PutBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLogging
     */
    default PutBucketLoggingResponse putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging
     * parameters. To set the logging status of a bucket, you must be the bucket owner.
     *
     * @param putBucketLoggingRequest
     * @return Result of the PutBucketLogging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketLogging
     */
    default PutBucketLoggingResponse putBucketLogging(Consumer<PutBucketLoggingRequest.Builder> putBucketLoggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketLogging(PutBucketLoggingRequest.builder().apply(putBucketLoggingRequest).build());
    }

    /**
     * Sets a metrics configuration (specified by the metrics configuration ID) for the bucket.
     *
     * @param putBucketMetricsConfigurationRequest
     * @return Result of the PutBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketMetricsConfiguration
     */
    default PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(
            PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets a metrics configuration (specified by the metrics configuration ID) for the bucket.
     *
     * @param putBucketMetricsConfigurationRequest
     * @return Result of the PutBucketMetricsConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketMetricsConfiguration
     */
    default PutBucketMetricsConfigurationResponse putBucketMetricsConfiguration(
            Consumer<PutBucketMetricsConfigurationRequest.Builder> putBucketMetricsConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketMetricsConfiguration(PutBucketMetricsConfigurationRequest.builder()
                .apply(putBucketMetricsConfigurationRequest).build());
    }

    /**
     * Deprecated, see the PutBucketNotificationConfiguraiton operation.
     *
     * @param putBucketNotificationRequest
     * @return Result of the PutBucketNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotification
     */
    default PutBucketNotificationResponse putBucketNotification(PutBucketNotificationRequest putBucketNotificationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Deprecated, see the PutBucketNotificationConfiguraiton operation.
     *
     * @param putBucketNotificationRequest
     * @return Result of the PutBucketNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotification
     */
    default PutBucketNotificationResponse putBucketNotification(
            Consumer<PutBucketNotificationRequest.Builder> putBucketNotificationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return putBucketNotification(PutBucketNotificationRequest.builder().apply(putBucketNotificationRequest).build());
    }

    /**
     * Enables notifications of specified events for a bucket.
     *
     * @param putBucketNotificationConfigurationRequest
     * @return Result of the PutBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotificationConfiguration
     */
    default PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(
            PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Enables notifications of specified events for a bucket.
     *
     * @param putBucketNotificationConfigurationRequest
     * @return Result of the PutBucketNotificationConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketNotificationConfiguration
     */
    default PutBucketNotificationConfigurationResponse putBucketNotificationConfiguration(
            Consumer<PutBucketNotificationConfigurationRequest.Builder> putBucketNotificationConfigurationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketNotificationConfiguration(PutBucketNotificationConfigurationRequest.builder()
                .apply(putBucketNotificationConfigurationRequest).build());
    }

    /**
     * Replaces a policy on a bucket. If the bucket already has a policy, the one in this request completely replaces
     * it.
     *
     * @param putBucketPolicyRequest
     * @return Result of the PutBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketPolicy
     */
    default PutBucketPolicyResponse putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Replaces a policy on a bucket. If the bucket already has a policy, the one in this request completely replaces
     * it.
     *
     * @param putBucketPolicyRequest
     * @return Result of the PutBucketPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketPolicy
     */
    default PutBucketPolicyResponse putBucketPolicy(Consumer<PutBucketPolicyRequest.Builder> putBucketPolicyRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketPolicy(PutBucketPolicyRequest.builder().apply(putBucketPolicyRequest).build());
    }

    /**
     * Creates a new replication configuration (or replaces an existing one, if present).
     *
     * @param putBucketReplicationRequest
     * @return Result of the PutBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketReplication
     */
    default PutBucketReplicationResponse putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new replication configuration (or replaces an existing one, if present).
     *
     * @param putBucketReplicationRequest
     * @return Result of the PutBucketReplication operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketReplication
     */
    default PutBucketReplicationResponse putBucketReplication(
            Consumer<PutBucketReplicationRequest.Builder> putBucketReplicationRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return putBucketReplication(PutBucketReplicationRequest.builder().apply(putBucketReplicationRequest).build());
    }

    /**
     * Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the
     * bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the
     * download will be charged for the download. Documentation on requester pays buckets can be found at
     * http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
     *
     * @param putBucketRequestPaymentRequest
     * @return Result of the PutBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketRequestPayment
     */
    default PutBucketRequestPaymentResponse putBucketRequestPayment(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the
     * bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the
     * download will be charged for the download. Documentation on requester pays buckets can be found at
     * http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
     *
     * @param putBucketRequestPaymentRequest
     * @return Result of the PutBucketRequestPayment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketRequestPayment
     */
    default PutBucketRequestPaymentResponse putBucketRequestPayment(
            Consumer<PutBucketRequestPaymentRequest.Builder> putBucketRequestPaymentRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return putBucketRequestPayment(PutBucketRequestPaymentRequest.builder().apply(putBucketRequestPaymentRequest).build());
    }

    /**
     * Sets the tags for a bucket.
     *
     * @param putBucketTaggingRequest
     * @return Result of the PutBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketTagging
     */
    default PutBucketTaggingResponse putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the tags for a bucket.
     *
     * @param putBucketTaggingRequest
     * @return Result of the PutBucketTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketTagging
     */
    default PutBucketTaggingResponse putBucketTagging(Consumer<PutBucketTaggingRequest.Builder> putBucketTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketTagging(PutBucketTaggingRequest.builder().apply(putBucketTaggingRequest).build());
    }

    /**
     * Sets the versioning state of an existing bucket. To set the versioning state, you must be the bucket owner.
     *
     * @param putBucketVersioningRequest
     * @return Result of the PutBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketVersioning
     */
    default PutBucketVersioningResponse putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the versioning state of an existing bucket. To set the versioning state, you must be the bucket owner.
     *
     * @param putBucketVersioningRequest
     * @return Result of the PutBucketVersioning operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketVersioning
     */
    default PutBucketVersioningResponse putBucketVersioning(
            Consumer<PutBucketVersioningRequest.Builder> putBucketVersioningRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        return putBucketVersioning(PutBucketVersioningRequest.builder().apply(putBucketVersioningRequest).build());
    }

    /**
     * Set the website configuration for a bucket.
     *
     * @param putBucketWebsiteRequest
     * @return Result of the PutBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketWebsite
     */
    default PutBucketWebsiteResponse putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the website configuration for a bucket.
     *
     * @param putBucketWebsiteRequest
     * @return Result of the PutBucketWebsite operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutBucketWebsite
     */
    default PutBucketWebsiteResponse putBucketWebsite(Consumer<PutBucketWebsiteRequest.Builder> putBucketWebsiteRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putBucketWebsite(PutBucketWebsiteRequest.builder().apply(putBucketWebsiteRequest).build());
    }

    /**
     * Adds an object to a bucket.
     *
     * @param putObjectRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.of(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows 'Object data.'
     * @return Result of the PutObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObject
     */
    default PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Adds an object to a bucket.
     *
     * @param putObjectRequest
     * @param path
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows 'Object data.'
     * @return Result of the PutObject operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObject
     * @see #putObject(PutObjectRequest, RequestBody)
     */
    default PutObjectResponse putObject(PutObjectRequest putObjectRequest, Path filePath) throws SdkServiceException,
            SdkClientException, S3Exception {
        return putObject(putObjectRequest, RequestBody.of(filePath));
    }

    /**
     * uses the acl subresource to set the access control list (ACL) permissions for an object that already exists in a
     * bucket
     *
     * @param putObjectAclRequest
     * @return Result of the PutObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObjectAcl
     */
    default PutObjectAclResponse putObjectAcl(PutObjectAclRequest putObjectAclRequest) throws NoSuchKeyException,
            SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * uses the acl subresource to set the access control list (ACL) permissions for an object that already exists in a
     * bucket
     *
     * @param putObjectAclRequest
     * @return Result of the PutObjectAcl operation returned by the service.
     * @throws NoSuchKeyException
     *         The specified key does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObjectAcl
     */
    default PutObjectAclResponse putObjectAcl(Consumer<PutObjectAclRequest.Builder> putObjectAclRequest)
            throws NoSuchKeyException, SdkServiceException, SdkClientException, S3Exception {
        return putObjectAcl(PutObjectAclRequest.builder().apply(putObjectAclRequest).build());
    }

    /**
     * Sets the supplied tag-set to an object that already exists in a bucket
     *
     * @param putObjectTaggingRequest
     * @return Result of the PutObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObjectTagging
     */
    default PutObjectTaggingResponse putObjectTagging(PutObjectTaggingRequest putObjectTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Sets the supplied tag-set to an object that already exists in a bucket
     *
     * @param putObjectTaggingRequest
     * @return Result of the PutObjectTagging operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.PutObjectTagging
     */
    default PutObjectTaggingResponse putObjectTagging(Consumer<PutObjectTaggingRequest.Builder> putObjectTaggingRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return putObjectTagging(PutObjectTaggingRequest.builder().apply(putObjectTaggingRequest).build());
    }

    /**
     * Restores an archived copy of an object back into Amazon S3
     *
     * @param restoreObjectRequest
     * @return Result of the RestoreObject operation returned by the service.
     * @throws ObjectAlreadyInActiveTierErrorException
     *         This operation is not allowed against this storage tier
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.RestoreObject
     */
    default RestoreObjectResponse restoreObject(RestoreObjectRequest restoreObjectRequest)
            throws ObjectAlreadyInActiveTierErrorException, SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Restores an archived copy of an object back into Amazon S3
     *
     * @param restoreObjectRequest
     * @return Result of the RestoreObject operation returned by the service.
     * @throws ObjectAlreadyInActiveTierErrorException
     *         This operation is not allowed against this storage tier
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.RestoreObject
     */
    default RestoreObjectResponse restoreObject(Consumer<RestoreObjectRequest.Builder> restoreObjectRequest)
            throws ObjectAlreadyInActiveTierErrorException, SdkServiceException, SdkClientException, S3Exception {
        return restoreObject(RestoreObjectRequest.builder().apply(restoreObjectRequest).build());
    }

    /**
     * <p>
     * Uploads a part in a multipart upload.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param uploadPartRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.of(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows 'Object data.'
     * @return Result of the UploadPart operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.UploadPart
     */
    default UploadPartResponse uploadPart(UploadPartRequest uploadPartRequest, RequestBody requestBody)
            throws SdkServiceException, SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a part in a multipart upload.
     * </p>
     * <p>
     * <b>Note:</b> After you initiate multipart upload and upload one or more parts, you must either complete or abort
     * multipart upload in order to stop getting charged for storage of the uploaded parts. Only after you either
     * complete or abort multipart upload, Amazon S3 frees up the parts storage and stops charging you for the parts
     * storage.
     * </p>
     *
     * @param uploadPartRequest
     * @param path
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows 'Object data.'
     * @return Result of the UploadPart operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.UploadPart
     * @see #uploadPart(UploadPartRequest, RequestBody)
     */
    default UploadPartResponse uploadPart(UploadPartRequest uploadPartRequest, Path filePath) throws SdkServiceException,
            SdkClientException, S3Exception {
        return uploadPart(uploadPartRequest, RequestBody.of(filePath));
    }

    /**
     * Uploads a part by copying data from an existing object as data source.
     *
     * @param uploadPartCopyRequest
     * @return Result of the UploadPartCopy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.UploadPartCopy
     */
    default UploadPartCopyResponse uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) throws SdkServiceException,
            SdkClientException, S3Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * Uploads a part by copying data from an existing object as data source.
     *
     * @param uploadPartCopyRequest
     * @return Result of the UploadPartCopy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws S3Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample S3Client.UploadPartCopy
     */
    default UploadPartCopyResponse uploadPartCopy(Consumer<UploadPartCopyRequest.Builder> uploadPartCopyRequest)
            throws SdkServiceException, SdkClientException, S3Exception {
        return uploadPartCopy(UploadPartCopyRequest.builder().apply(uploadPartCopyRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("s3");
    }
}
