/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AnalyticsS3BucketDestination implements
        ToCopyableBuilder<AnalyticsS3BucketDestination.Builder, AnalyticsS3BucketDestination> {
    private final String format;

    private final String bucketAccountId;

    private final String bucket;

    private final String prefix;

    private AnalyticsS3BucketDestination(BuilderImpl builder) {
        this.format = builder.format;
        this.bucketAccountId = builder.bucketAccountId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * The file format used when exporting data to Amazon S3.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalyticsS3ExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatString}.
     * </p>
     * 
     * @return The file format used when exporting data to Amazon S3.
     * @see AnalyticsS3ExportFileFormat
     */
    public AnalyticsS3ExportFileFormat format() {
        return AnalyticsS3ExportFileFormat.fromValue(format);
    }

    /**
     * The file format used when exporting data to Amazon S3.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalyticsS3ExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatString}.
     * </p>
     * 
     * @return The file format used when exporting data to Amazon S3.
     * @see AnalyticsS3ExportFileFormat
     */
    public String formatString() {
        return format;
    }

    /**
     * The account ID that owns the destination bucket. If no account ID is provided, the owner will not be validated
     * prior to exporting data.
     * 
     * @return The account ID that owns the destination bucket. If no account ID is provided, the owner will not be
     *         validated prior to exporting data.
     */
    public String bucketAccountId() {
        return bucketAccountId;
    }

    /**
     * The Amazon resource name (ARN) of the bucket to which data is exported.
     * 
     * @return The Amazon resource name (ARN) of the bucket to which data is exported.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The prefix to use when exporting data. The exported data begins with this prefix.
     * 
     * @return The prefix to use when exporting data. The exported data begins with this prefix.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatString());
        hashCode = 31 * hashCode + Objects.hashCode(bucketAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsS3BucketDestination)) {
            return false;
        }
        AnalyticsS3BucketDestination other = (AnalyticsS3BucketDestination) obj;
        return Objects.equals(formatString(), other.formatString()) && Objects.equals(bucketAccountId(), other.bucketAccountId())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(prefix(), other.prefix());
    }

    @Override
    public String toString() {
        return ToString.builder("AnalyticsS3BucketDestination").add("Format", formatString())
                .add("BucketAccountId", bucketAccountId()).add("Bucket", bucket()).add("Prefix", prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.of(clazz.cast(formatString()));
        case "BucketAccountId":
            return Optional.of(clazz.cast(bucketAccountId()));
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AnalyticsS3BucketDestination> {
        /**
         * The file format used when exporting data to Amazon S3.
         * 
         * @param format
         *        The file format used when exporting data to Amazon S3.
         * @see AnalyticsS3ExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsS3ExportFileFormat
         */
        Builder format(String format);

        /**
         * The file format used when exporting data to Amazon S3.
         * 
         * @param format
         *        The file format used when exporting data to Amazon S3.
         * @see AnalyticsS3ExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsS3ExportFileFormat
         */
        Builder format(AnalyticsS3ExportFileFormat format);

        /**
         * The account ID that owns the destination bucket. If no account ID is provided, the owner will not be
         * validated prior to exporting data.
         * 
         * @param bucketAccountId
         *        The account ID that owns the destination bucket. If no account ID is provided, the owner will not be
         *        validated prior to exporting data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketAccountId(String bucketAccountId);

        /**
         * The Amazon resource name (ARN) of the bucket to which data is exported.
         * 
         * @param bucket
         *        The Amazon resource name (ARN) of the bucket to which data is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The prefix to use when exporting data. The exported data begins with this prefix.
         * 
         * @param prefix
         *        The prefix to use when exporting data. The exported data begins with this prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String bucketAccountId;

        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsS3BucketDestination model) {
            format(model.format);
            bucketAccountId(model.bucketAccountId);
            bucket(model.bucket);
            prefix(model.prefix);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalyticsS3ExportFileFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getBucketAccountId() {
            return bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public AnalyticsS3BucketDestination build() {
            return new AnalyticsS3BucketDestination(this);
        }
    }
}
