/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompletedMultipartUpload implements ToCopyableBuilder<CompletedMultipartUpload.Builder, CompletedMultipartUpload> {
    private final List<CompletedPart> parts;

    private CompletedMultipartUpload(BuilderImpl builder) {
        this.parts = builder.parts;
    }

    /**
     * Returns the value of the Parts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Parts property for this object.
     */
    public List<CompletedPart> parts() {
        return parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload other = (CompletedMultipartUpload) obj;
        return Objects.equals(parts(), other.parts());
    }

    @Override
    public String toString() {
        return ToString.builder("CompletedMultipartUpload").add("Parts", parts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parts":
            return Optional.of(clazz.cast(parts()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CompletedMultipartUpload> {
        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<CompletedPart> parts);

        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(CompletedPart... parts);
    }

    static final class BuilderImpl implements Builder {
        private List<CompletedPart> parts;

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedMultipartUpload model) {
            parts(model.parts);
        }

        public final Collection<CompletedPart.Builder> getParts() {
            return parts != null ? parts.stream().map(CompletedPart::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompletedPart... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        public final void setParts(Collection<CompletedPart.BuilderImpl> parts) {
            this.parts = CompletedPartListCopier.copyFromBuilder(parts);
        }

        @Override
        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }
    }
}
