/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Condition implements ToCopyableBuilder<Condition.Builder, Condition> {
    private final String httpErrorCodeReturnedEquals;

    private final String keyPrefixEquals;

    private Condition(BuilderImpl builder) {
        this.httpErrorCodeReturnedEquals = builder.httpErrorCodeReturnedEquals;
        this.keyPrefixEquals = builder.keyPrefixEquals;
    }

    /**
     * The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this value,
     * then the specified redirect is applied. Required when parent element Condition is specified and sibling
     * KeyPrefixEquals is not specified. If both are specified, then both must be true for the redirect to be applied.
     * 
     * @return The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this
     *         value, then the specified redirect is applied. Required when parent element Condition is specified and
     *         sibling KeyPrefixEquals is not specified. If both are specified, then both must be true for the redirect
     *         to be applied.
     */
    public String httpErrorCodeReturnedEquals() {
        return httpErrorCodeReturnedEquals;
    }

    /**
     * The object key name prefix when the redirect is applied. For example, to redirect requests for ExamplePage.html,
     * the key prefix will be ExamplePage.html. To redirect request for all pages with the prefix docs/, the key prefix
     * will be /docs, which identifies all objects in the docs/ folder. Required when the parent element Condition is
     * specified and sibling HttpErrorCodeReturnedEquals is not specified. If both conditions are specified, both must
     * be true for the redirect to be applied.
     * 
     * @return The object key name prefix when the redirect is applied. For example, to redirect requests for
     *         ExamplePage.html, the key prefix will be ExamplePage.html. To redirect request for all pages with the
     *         prefix docs/, the key prefix will be /docs, which identifies all objects in the docs/ folder. Required
     *         when the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals is not specified.
     *         If both conditions are specified, both must be true for the redirect to be applied.
     */
    public String keyPrefixEquals() {
        return keyPrefixEquals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpErrorCodeReturnedEquals());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefixEquals());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(httpErrorCodeReturnedEquals(), other.httpErrorCodeReturnedEquals())
                && Objects.equals(keyPrefixEquals(), other.keyPrefixEquals());
    }

    @Override
    public String toString() {
        return ToString.builder("Condition").add("HttpErrorCodeReturnedEquals", httpErrorCodeReturnedEquals())
                .add("KeyPrefixEquals", keyPrefixEquals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpErrorCodeReturnedEquals":
            return Optional.of(clazz.cast(httpErrorCodeReturnedEquals()));
        case "KeyPrefixEquals":
            return Optional.of(clazz.cast(keyPrefixEquals()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Condition> {
        /**
         * The HTTP error code when the redirect is applied. In the event of an error, if the error code equals this
         * value, then the specified redirect is applied. Required when parent element Condition is specified and
         * sibling KeyPrefixEquals is not specified. If both are specified, then both must be true for the redirect to
         * be applied.
         * 
         * @param httpErrorCodeReturnedEquals
         *        The HTTP error code when the redirect is applied. In the event of an error, if the error code equals
         *        this value, then the specified redirect is applied. Required when parent element Condition is
         *        specified and sibling KeyPrefixEquals is not specified. If both are specified, then both must be true
         *        for the redirect to be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals);

        /**
         * The object key name prefix when the redirect is applied. For example, to redirect requests for
         * ExamplePage.html, the key prefix will be ExamplePage.html. To redirect request for all pages with the prefix
         * docs/, the key prefix will be /docs, which identifies all objects in the docs/ folder. Required when the
         * parent element Condition is specified and sibling HttpErrorCodeReturnedEquals is not specified. If both
         * conditions are specified, both must be true for the redirect to be applied.
         * 
         * @param keyPrefixEquals
         *        The object key name prefix when the redirect is applied. For example, to redirect requests for
         *        ExamplePage.html, the key prefix will be ExamplePage.html. To redirect request for all pages with the
         *        prefix docs/, the key prefix will be /docs, which identifies all objects in the docs/ folder. Required
         *        when the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals is not
         *        specified. If both conditions are specified, both must be true for the redirect to be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefixEquals(String keyPrefixEquals);
    }

    static final class BuilderImpl implements Builder {
        private String httpErrorCodeReturnedEquals;

        private String keyPrefixEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            httpErrorCodeReturnedEquals(model.httpErrorCodeReturnedEquals);
            keyPrefixEquals(model.keyPrefixEquals);
        }

        public final String getHttpErrorCodeReturnedEquals() {
            return httpErrorCodeReturnedEquals;
        }

        @Override
        public final Builder httpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
            return this;
        }

        public final void setHttpErrorCodeReturnedEquals(String httpErrorCodeReturnedEquals) {
            this.httpErrorCodeReturnedEquals = httpErrorCodeReturnedEquals;
        }

        public final String getKeyPrefixEquals() {
            return keyPrefixEquals;
        }

        @Override
        public final Builder keyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
            return this;
        }

        public final void setKeyPrefixEquals(String keyPrefixEquals) {
            this.keyPrefixEquals = keyPrefixEquals;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }
    }
}
