/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteObjectsResponse extends S3Response implements
        ToCopyableBuilder<DeleteObjectsResponse.Builder, DeleteObjectsResponse> {
    private final List<DeletedObject> deleted;

    private final String requestCharged;

    private final List<S3Error> errors;

    private DeleteObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.deleted = builder.deleted;
        this.requestCharged = builder.requestCharged;
        this.errors = builder.errors;
    }

    /**
     * Returns the value of the Deleted property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Deleted property for this object.
     */
    public List<DeletedObject> deleted() {
        return deleted;
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(requestCharged);
    }

    /**
     * Returns the value of the RequestCharged property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestCharged}
     * will return {@link RequestCharged#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestChargedString}.
     * </p>
     * 
     * @return The value of the RequestCharged property for this object.
     * @see RequestCharged
     */
    public String requestChargedString() {
        return requestCharged;
    }

    /**
     * Returns the value of the Errors property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Errors property for this object.
     */
    public List<S3Error> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(requestChargedString());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsResponse)) {
            return false;
        }
        DeleteObjectsResponse other = (DeleteObjectsResponse) obj;
        return Objects.equals(deleted(), other.deleted()) && Objects.equals(requestChargedString(), other.requestChargedString())
                && Objects.equals(errors(), other.errors());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteObjectsResponse").add("Deleted", deleted()).add("RequestCharged", requestChargedString())
                .add("Errors", errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deleted":
            return Optional.of(clazz.cast(deleted()));
        case "RequestCharged":
            return Optional.of(clazz.cast(requestChargedString()));
        case "Errors":
            return Optional.of(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, DeleteObjectsResponse> {
        /**
         * Sets the value of the Deleted property for this object.
         *
         * @param deleted
         *        The new value for the Deleted property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Collection<DeletedObject> deleted);

        /**
         * Sets the value of the Deleted property for this object.
         *
         * @param deleted
         *        The new value for the Deleted property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(DeletedObject... deleted);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         * Sets the value of the RequestCharged property for this object.
         *
         * @param requestCharged
         *        The new value for the RequestCharged property for this object.
         * @see RequestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);

        /**
         * Sets the value of the Errors property for this object.
         *
         * @param errors
         *        The new value for the Errors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<S3Error> errors);

        /**
         * Sets the value of the Errors property for this object.
         *
         * @param errors
         *        The new value for the Errors property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(S3Error... errors);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<DeletedObject> deleted;

        private String requestCharged;

        private List<S3Error> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsResponse model) {
            deleted(model.deleted);
            requestCharged(model.requestCharged);
            errors(model.errors);
        }

        public final Collection<DeletedObject.Builder> getDeleted() {
            return deleted != null ? deleted.stream().map(DeletedObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedObject... deleted) {
            deleted(Arrays.asList(deleted));
            return this;
        }

        public final void setDeleted(Collection<DeletedObject.BuilderImpl> deleted) {
            this.deleted = DeletedObjectsCopier.copyFromBuilder(deleted);
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final Collection<S3Error.Builder> getErrors() {
            return errors != null ? errors.stream().map(S3Error::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(S3Error... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<S3Error.BuilderImpl> errors) {
            this.errors = ErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public DeleteObjectsResponse build() {
            return new DeleteObjectsResponse(this);
        }
    }
}
