/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketAccelerateConfigurationResponse extends S3Response implements
        ToCopyableBuilder<GetBucketAccelerateConfigurationResponse.Builder, GetBucketAccelerateConfigurationResponse> {
    private final String status;

    private GetBucketAccelerateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * The accelerate configuration of the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BucketAccelerateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The accelerate configuration of the bucket.
     * @see BucketAccelerateStatus
     */
    public BucketAccelerateStatus status() {
        return BucketAccelerateStatus.fromValue(status);
    }

    /**
     * The accelerate configuration of the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BucketAccelerateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The accelerate configuration of the bucket.
     * @see BucketAccelerateStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAccelerateConfigurationResponse)) {
            return false;
        }
        GetBucketAccelerateConfigurationResponse other = (GetBucketAccelerateConfigurationResponse) obj;
        return Objects.equals(statusString(), other.statusString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketAccelerateConfigurationResponse").add("Status", statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, GetBucketAccelerateConfigurationResponse> {
        /**
         * The accelerate configuration of the bucket.
         * 
         * @param status
         *        The accelerate configuration of the bucket.
         * @see BucketAccelerateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketAccelerateStatus
         */
        Builder status(String status);

        /**
         * The accelerate configuration of the bucket.
         * 
         * @param status
         *        The accelerate configuration of the bucket.
         * @see BucketAccelerateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketAccelerateStatus
         */
        Builder status(BucketAccelerateStatus status);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAccelerateConfigurationResponse model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BucketAccelerateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public GetBucketAccelerateConfigurationResponse build() {
            return new GetBucketAccelerateConfigurationResponse(this);
        }
    }
}
