/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBucketTaggingResponse extends S3Response implements
        ToCopyableBuilder<GetBucketTaggingResponse.Builder, GetBucketTaggingResponse> {
    private final List<Tag> tagSet;

    private GetBucketTaggingResponse(BuilderImpl builder) {
        super(builder);
        this.tagSet = builder.tagSet;
    }

    /**
     * Returns the value of the TagSet property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the TagSet property for this object.
     */
    public List<Tag> tagSet() {
        return tagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketTaggingResponse)) {
            return false;
        }
        GetBucketTaggingResponse other = (GetBucketTaggingResponse) obj;
        return Objects.equals(tagSet(), other.tagSet());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBucketTaggingResponse").add("TagSet", tagSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagSet":
            return Optional.of(clazz.cast(tagSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, GetBucketTaggingResponse> {
        /**
         * Sets the value of the TagSet property for this object.
         *
         * @param tagSet
         *        The new value for the TagSet property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Collection<Tag> tagSet);

        /**
         * Sets the value of the TagSet property for this object.
         *
         * @param tagSet
         *        The new value for the TagSet property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Tag... tagSet);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<Tag> tagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketTaggingResponse model) {
            tagSet(model.tagSet);
        }

        public final Collection<Tag.Builder> getTagSet() {
            return tagSet != null ? tagSet.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
            return this;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagSetCopier.copyFromBuilder(tagSet);
        }

        @Override
        public GetBucketTaggingResponse build() {
            return new GetBucketTaggingResponse(this);
        }
    }
}
