/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class InventorySchedule implements ToCopyableBuilder<InventorySchedule.Builder, InventorySchedule> {
    private final String frequency;

    private InventorySchedule(BuilderImpl builder) {
        this.frequency = builder.frequency;
    }

    /**
     * Specifies how frequently inventory results are produced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link InventoryFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyString}.
     * </p>
     * 
     * @return Specifies how frequently inventory results are produced.
     * @see InventoryFrequency
     */
    public InventoryFrequency frequency() {
        return InventoryFrequency.fromValue(frequency);
    }

    /**
     * Specifies how frequently inventory results are produced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link InventoryFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyString}.
     * </p>
     * 
     * @return Specifies how frequently inventory results are produced.
     * @see InventoryFrequency
     */
    public String frequencyString() {
        return frequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frequencyString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventorySchedule)) {
            return false;
        }
        InventorySchedule other = (InventorySchedule) obj;
        return Objects.equals(frequencyString(), other.frequencyString());
    }

    @Override
    public String toString() {
        return ToString.builder("InventorySchedule").add("Frequency", frequencyString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frequency":
            return Optional.of(clazz.cast(frequencyString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InventorySchedule> {
        /**
         * Specifies how frequently inventory results are produced.
         * 
         * @param frequency
         *        Specifies how frequently inventory results are produced.
         * @see InventoryFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryFrequency
         */
        Builder frequency(String frequency);

        /**
         * Specifies how frequently inventory results are produced.
         * 
         * @param frequency
         *        Specifies how frequently inventory results are produced.
         * @see InventoryFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryFrequency
         */
        Builder frequency(InventoryFrequency frequency);
    }

    static final class BuilderImpl implements Builder {
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(InventorySchedule model) {
            frequency(model.frequency);
        }

        public final String getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(InventoryFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public InventorySchedule build() {
            return new InventorySchedule(this);
        }
    }
}
