/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will
 * apply to any object matching all of the predicates configured inside the And operator.
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleRuleAndOperator implements ToCopyableBuilder<LifecycleRuleAndOperator.Builder, LifecycleRuleAndOperator> {
    private final String prefix;

    private final List<Tag> tags;

    private LifecycleRuleAndOperator(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the Prefix property for this object.
     * 
     * @return The value of the Prefix property for this object.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * All of these tags must exist in the object's tag set in order for the rule to apply.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRuleAndOperator)) {
            return false;
        }
        LifecycleRuleAndOperator other = (LifecycleRuleAndOperator) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("LifecycleRuleAndOperator").add("Prefix", prefix()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleRuleAndOperator> {
        /**
         * Sets the value of the Prefix property for this object.
         *
         * @param prefix
         *        The new value for the Prefix property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * All of these tags must exist in the object's tag set in order for the rule to apply.
         * 
         * @param tags
         *        All of these tags must exist in the object's tag set in order for the rule to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * All of these tags must exist in the object's tag set in order for the rule to apply.
         * 
         * @param tags
         *        All of these tags must exist in the object's tag set in order for the rule to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRuleAndOperator model) {
            prefix(model.prefix);
            tags(model.tags);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagSetCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagSetCopier.copyFromBuilder(tags);
        }

        @Override
        public LifecycleRuleAndOperator build() {
            return new LifecycleRuleAndOperator(this);
        }
    }
}
