/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListBucketsResponse extends S3Response implements
        ToCopyableBuilder<ListBucketsResponse.Builder, ListBucketsResponse> {
    private final List<Bucket> buckets;

    private final Owner owner;

    private ListBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.owner = builder.owner;
    }

    /**
     * Returns the value of the Buckets property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Buckets property for this object.
     */
    public List<Bucket> buckets() {
        return buckets;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public Owner owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(buckets());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsResponse)) {
            return false;
        }
        ListBucketsResponse other = (ListBucketsResponse) obj;
        return Objects.equals(buckets(), other.buckets()) && Objects.equals(owner(), other.owner());
    }

    @Override
    public String toString() {
        return ToString.builder("ListBucketsResponse").add("Buckets", buckets()).add("Owner", owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Buckets":
            return Optional.of(clazz.cast(buckets()));
        case "Owner":
            return Optional.of(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Response.Builder, CopyableBuilder<Builder, ListBucketsResponse> {
        /**
         * Sets the value of the Buckets property for this object.
         *
         * @param buckets
         *        The new value for the Buckets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<Bucket> buckets);

        /**
         * Sets the value of the Buckets property for this object.
         *
         * @param buckets
         *        The new value for the Buckets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Bucket... buckets);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * Sets the value of the Owner property for this object.
         *
         * This is a convenience that creates an instance of the {@link Owner.Builder} avoiding the need to create one
         * manually via {@link Owner#builder()}.
         *
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().apply(owner).build());
        }
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<Bucket> buckets;

        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsResponse model) {
            buckets(model.buckets);
            owner(model.owner);
        }

        public final Collection<Bucket.Builder> getBuckets() {
            return buckets != null ? buckets.stream().map(Bucket::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketsCopier.copyFromBuilder(buckets);
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public ListBucketsResponse build() {
            return new ListBucketsResponse(this);
        }
    }
}
