/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketAnalyticsConfigurationRequest extends S3Request implements
        ToCopyableBuilder<PutBucketAnalyticsConfigurationRequest.Builder, PutBucketAnalyticsConfigurationRequest> {
    private final String bucket;

    private final String id;

    private final AnalyticsConfiguration analyticsConfiguration;

    private PutBucketAnalyticsConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.id = builder.id;
        this.analyticsConfiguration = builder.analyticsConfiguration;
    }

    /**
     * The name of the bucket to which an analytics configuration is stored.
     * 
     * @return The name of the bucket to which an analytics configuration is stored.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The identifier used to represent an analytics configuration.
     * 
     * @return The identifier used to represent an analytics configuration.
     */
    public String id() {
        return id;
    }

    /**
     * The configuration and any analyses for the analytics filter.
     * 
     * @return The configuration and any analyses for the analytics filter.
     */
    public AnalyticsConfiguration analyticsConfiguration() {
        return analyticsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAnalyticsConfigurationRequest)) {
            return false;
        }
        PutBucketAnalyticsConfigurationRequest other = (PutBucketAnalyticsConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(id(), other.id())
                && Objects.equals(analyticsConfiguration(), other.analyticsConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketAnalyticsConfigurationRequest").add("Bucket", bucket()).add("Id", id())
                .add("AnalyticsConfiguration", analyticsConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "AnalyticsConfiguration":
            return Optional.of(clazz.cast(analyticsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketAnalyticsConfigurationRequest> {
        /**
         * The name of the bucket to which an analytics configuration is stored.
         * 
         * @param bucket
         *        The name of the bucket to which an analytics configuration is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The identifier used to represent an analytics configuration.
         * 
         * @param id
         *        The identifier used to represent an analytics configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The configuration and any analyses for the analytics filter.
         * 
         * @param analyticsConfiguration
         *        The configuration and any analyses for the analytics filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration);

        /**
         * The configuration and any analyses for the analytics filter. This is a convenience that creates an instance
         * of the {@link AnalyticsConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnalyticsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalyticsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #analyticsConfiguration(AnalyticsConfiguration)}.
         * 
         * @param analyticsConfiguration
         *        a consumer that will call methods on {@link AnalyticsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyticsConfiguration(AnalyticsConfiguration)
         */
        default Builder analyticsConfiguration(Consumer<AnalyticsConfiguration.Builder> analyticsConfiguration) {
            return analyticsConfiguration(AnalyticsConfiguration.builder().apply(analyticsConfiguration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String id;

        private AnalyticsConfiguration analyticsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAnalyticsConfigurationRequest model) {
            bucket(model.bucket);
            id(model.id);
            analyticsConfiguration(model.analyticsConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final AnalyticsConfiguration.Builder getAnalyticsConfiguration() {
            return analyticsConfiguration != null ? analyticsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder analyticsConfiguration(AnalyticsConfiguration analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        public final void setAnalyticsConfiguration(AnalyticsConfiguration.BuilderImpl analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration != null ? analyticsConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketAnalyticsConfigurationRequest build() {
            return new PutBucketAnalyticsConfigurationRequest(this);
        }
    }
}
