/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketLoggingRequest extends S3Request implements
        ToCopyableBuilder<PutBucketLoggingRequest.Builder, PutBucketLoggingRequest> {
    private final String bucket;

    private final BucketLoggingStatus bucketLoggingStatus;

    private final String contentMD5;

    private PutBucketLoggingRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.bucketLoggingStatus = builder.bucketLoggingStatus;
        this.contentMD5 = builder.contentMD5;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the BucketLoggingStatus property for this object.
     * 
     * @return The value of the BucketLoggingStatus property for this object.
     */
    public BucketLoggingStatus bucketLoggingStatus() {
        return bucketLoggingStatus;
    }

    /**
     * Returns the value of the ContentMD5 property for this object.
     * 
     * @return The value of the ContentMD5 property for this object.
     */
    public String contentMD5() {
        return contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLoggingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLoggingRequest)) {
            return false;
        }
        PutBucketLoggingRequest other = (PutBucketLoggingRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(bucketLoggingStatus(), other.bucketLoggingStatus())
                && Objects.equals(contentMD5(), other.contentMD5());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketLoggingRequest").add("Bucket", bucket())
                .add("BucketLoggingStatus", bucketLoggingStatus()).add("ContentMD5", contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "BucketLoggingStatus":
            return Optional.of(clazz.cast(bucketLoggingStatus()));
        case "ContentMD5":
            return Optional.of(clazz.cast(contentMD5()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketLoggingRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the BucketLoggingStatus property for this object.
         *
         * @param bucketLoggingStatus
         *        The new value for the BucketLoggingStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus);

        /**
         * Sets the value of the BucketLoggingStatus property for this object.
         *
         * This is a convenience that creates an instance of the {@link BucketLoggingStatus.Builder} avoiding the need
         * to create one manually via {@link BucketLoggingStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketLoggingStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #bucketLoggingStatus(BucketLoggingStatus)}.
         * 
         * @param bucketLoggingStatus
         *        a consumer that will call methods on {@link BucketLoggingStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLoggingStatus(BucketLoggingStatus)
         */
        default Builder bucketLoggingStatus(Consumer<BucketLoggingStatus.Builder> bucketLoggingStatus) {
            return bucketLoggingStatus(BucketLoggingStatus.builder().apply(bucketLoggingStatus).build());
        }

        /**
         * Sets the value of the ContentMD5 property for this object.
         *
         * @param contentMD5
         *        The new value for the ContentMD5 property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private BucketLoggingStatus bucketLoggingStatus;

        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLoggingRequest model) {
            bucket(model.bucket);
            bucketLoggingStatus(model.bucketLoggingStatus);
            contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLoggingStatus.Builder getBucketLoggingStatus() {
            return bucketLoggingStatus != null ? bucketLoggingStatus.toBuilder() : null;
        }

        @Override
        public final Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus;
            return this;
        }

        public final void setBucketLoggingStatus(BucketLoggingStatus.BuilderImpl bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus != null ? bucketLoggingStatus.build() : null;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketLoggingRequest build() {
            return new PutBucketLoggingRequest(this);
        }
    }
}
