/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutBucketNotificationConfigurationRequest extends S3Request implements
        ToCopyableBuilder<PutBucketNotificationConfigurationRequest.Builder, PutBucketNotificationConfigurationRequest> {
    private final String bucket;

    private final NotificationConfiguration notificationConfiguration;

    private PutBucketNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    /**
     * Returns the value of the Bucket property for this object.
     * 
     * @return The value of the Bucket property for this object.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Returns the value of the NotificationConfiguration property for this object.
     * 
     * @return The value of the NotificationConfiguration property for this object.
     */
    public NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketNotificationConfigurationRequest)) {
            return false;
        }
        PutBucketNotificationConfigurationRequest other = (PutBucketNotificationConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketNotificationConfigurationRequest").add("Bucket", bucket())
                .add("NotificationConfiguration", notificationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "NotificationConfiguration":
            return Optional.of(clazz.cast(notificationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends S3Request.Builder, CopyableBuilder<Builder, PutBucketNotificationConfigurationRequest> {
        /**
         * Sets the value of the Bucket property for this object.
         *
         * @param bucket
         *        The new value for the Bucket property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Sets the value of the NotificationConfiguration property for this object.
         *
         * @param notificationConfiguration
         *        The new value for the NotificationConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * Sets the value of the NotificationConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link NotificationConfiguration.Builder} avoiding the
         * need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().apply(notificationConfiguration).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketNotificationConfigurationRequest model) {
            bucket(model.bucket);
            notificationConfiguration(model.notificationConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketNotificationConfigurationRequest build() {
            return new PutBucketNotificationConfigurationRequest(this);
        }
    }
}
