/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RedirectAllRequestsTo implements ToCopyableBuilder<RedirectAllRequestsTo.Builder, RedirectAllRequestsTo> {
    private final String hostName;

    private final String protocol;

    private RedirectAllRequestsTo(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.protocol = builder.protocol;
    }

    /**
     * Name of the host where requests will be redirected.
     * 
     * @return Name of the host where requests will be redirected.
     */
    public String hostName() {
        return hostName;
    }

    /**
     * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the original
     * request.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
     *         original request.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the original
     * request.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolString}.
     * </p>
     * 
     * @return Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
     *         original request.
     * @see Protocol
     */
    public String protocolString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(protocolString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectAllRequestsTo)) {
            return false;
        }
        RedirectAllRequestsTo other = (RedirectAllRequestsTo) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(protocolString(), other.protocolString());
    }

    @Override
    public String toString() {
        return ToString.builder("RedirectAllRequestsTo").add("HostName", hostName()).add("Protocol", protocolString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostName":
            return Optional.of(clazz.cast(hostName()));
        case "Protocol":
            return Optional.of(clazz.cast(protocolString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RedirectAllRequestsTo> {
        /**
         * Name of the host where requests will be redirected.
         * 
         * @param hostName
         *        Name of the host where requests will be redirected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in the
         * original request.
         * 
         * @param protocol
         *        Protocol to use (http, https) when redirecting requests. The default is the protocol that is used in
         *        the original request.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(RedirectAllRequestsTo model) {
            hostName(model.hostName);
            protocol(model.protocol);
        }

        public final String getHostName() {
            return hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public RedirectAllRequestsTo build() {
            return new RedirectAllRequestsTo(this);
        }
    }
}
