/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetGrant implements ToCopyableBuilder<TargetGrant.Builder, TargetGrant> {
    private final Grantee grantee;

    private final String permission;

    private TargetGrant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    /**
     * Returns the value of the Grantee property for this object.
     * 
     * @return The value of the Grantee property for this object.
     */
    public Grantee grantee() {
        return grantee;
    }

    /**
     * Logging permissions assigned to the Grantee for the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link BucketLogsPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return Logging permissions assigned to the Grantee for the bucket.
     * @see BucketLogsPermission
     */
    public BucketLogsPermission permission() {
        return BucketLogsPermission.fromValue(permission);
    }

    /**
     * Logging permissions assigned to the Grantee for the bucket.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link BucketLogsPermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionString}.
     * </p>
     * 
     * @return Logging permissions assigned to the Grantee for the bucket.
     * @see BucketLogsPermission
     */
    public String permissionString() {
        return permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        hashCode = 31 * hashCode + Objects.hashCode(permissionString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGrant)) {
            return false;
        }
        TargetGrant other = (TargetGrant) obj;
        return Objects.equals(grantee(), other.grantee()) && Objects.equals(permissionString(), other.permissionString());
    }

    @Override
    public String toString() {
        return ToString.builder("TargetGrant").add("Grantee", grantee()).add("Permission", permissionString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Grantee":
            return Optional.of(clazz.cast(grantee()));
        case "Permission":
            return Optional.of(clazz.cast(permissionString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TargetGrant> {
        /**
         * Sets the value of the Grantee property for this object.
         *
         * @param grantee
         *        The new value for the Grantee property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(Grantee grantee);

        /**
         * Sets the value of the Grantee property for this object.
         *
         * This is a convenience that creates an instance of the {@link Grantee.Builder} avoiding the need to create one
         * manually via {@link Grantee#builder()}.
         *
         * When the {@link Consumer} completes, {@link Grantee.Builder#build()} is called immediately and its result is
         * passed to {@link #grantee(Grantee)}.
         * 
         * @param grantee
         *        a consumer that will call methods on {@link Grantee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantee(Grantee)
         */
        default Builder grantee(Consumer<Grantee.Builder> grantee) {
            return grantee(Grantee.builder().apply(grantee).build());
        }

        /**
         * Logging permissions assigned to the Grantee for the bucket.
         * 
         * @param permission
         *        Logging permissions assigned to the Grantee for the bucket.
         * @see BucketLogsPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLogsPermission
         */
        Builder permission(String permission);

        /**
         * Logging permissions assigned to the Grantee for the bucket.
         * 
         * @param permission
         *        Logging permissions assigned to the Grantee for the bucket.
         * @see BucketLogsPermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketLogsPermission
         */
        Builder permission(BucketLogsPermission permission);
    }

    static final class BuilderImpl implements Builder {
        private Grantee grantee;

        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGrant model) {
            grantee(model.grantee);
            permission(model.permission);
        }

        public final Grantee.Builder getGrantee() {
            return grantee != null ? grantee.toBuilder() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        public final String getPermission() {
            return permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(BucketLogsPermission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public TargetGrant build() {
            return new TargetGrant(this);
        }
    }
}
