/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Transition implements ToCopyableBuilder<Transition.Builder, Transition> {
    private final Instant date;

    private final Integer days;

    private final String storageClass;

    private Transition(BuilderImpl builder) {
        this.date = builder.date;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    /**
     * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     * 
     * @return Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
     */
    public Instant date() {
        return date;
    }

    /**
     * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
     * positive integer.
     * 
     * @return Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
     *         non-zero positive integer.
     */
    public Integer days() {
        return days;
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TransitionStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see TransitionStorageClass
     */
    public TransitionStorageClass storageClass() {
        return TransitionStorageClass.fromValue(storageClass);
    }

    /**
     * The class of storage used to store the object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link TransitionStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #storageClassString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see TransitionStorageClass
     */
    public String storageClassString() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(days(), other.days())
                && Objects.equals(storageClassString(), other.storageClassString());
    }

    @Override
    public String toString() {
        return ToString.builder("Transition").add("Date", date()).add("Days", days()).add("StorageClass", storageClassString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.of(clazz.cast(date()));
        case "Days":
            return Optional.of(clazz.cast(days()));
        case "StorageClass":
            return Optional.of(clazz.cast(storageClassString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Transition> {
        /**
         * Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * 
         * @param date
         *        Indicates at what date the object is to be moved or deleted. Should be in GMT ISO 8601 Format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero
         * positive integer.
         * 
         * @param days
         *        Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a
         *        non-zero positive integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see TransitionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionStorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see TransitionStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitionStorageClass
         */
        Builder storageClass(TransitionStorageClass storageClass);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private Integer days;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Transition model) {
            date(model.date);
            days(model.days);
            storageClass(model.storageClass);
        }

        public final Instant getDate() {
            return date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public Transition build() {
            return new Transition(this);
        }
    }
}
