/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * BucketLifecycleConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BucketLifecycleConfigurationUnmarshaller implements
        Unmarshaller<BucketLifecycleConfiguration, StaxUnmarshallerContext> {

    public BucketLifecycleConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        BucketLifecycleConfiguration.Builder bucketLifecycleConfiguration = BucketLifecycleConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<LifecycleRule> rules = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                bucketLifecycleConfiguration.rules(rules);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Rule", targetDepth)) {
                    if (rules == null) {
                        rules = new ArrayList<>();
                    }
                    rules.add(LifecycleRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    bucketLifecycleConfiguration.rules(rules);
                    break;
                }
            }
        }
        return bucketLifecycleConfiguration.build();
    }

    private static final BucketLifecycleConfigurationUnmarshaller INSTANCE = new BucketLifecycleConfigurationUnmarshaller();

    public static BucketLifecycleConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
