/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.XmlWriter;

/**
 * CompleteMultipartUploadRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CompleteMultipartUploadRequestMarshaller implements
        Marshaller<Request<CompleteMultipartUploadRequest>, CompleteMultipartUploadRequest> {

    public Request<CompleteMultipartUploadRequest> marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest) {

        if (completeMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CompleteMultipartUploadRequest> request = new DefaultRequest<CompleteMultipartUploadRequest>(
                completeMultipartUploadRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.POST);

        if (completeMultipartUploadRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(completeMultipartUploadRequest.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", completeMultipartUploadRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                completeMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);

        if (completeMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(completeMultipartUploadRequest.uploadId()));
        }

        try {
            StringWriter stringWriter = null;
            CompletedMultipartUpload multipartUpload = completeMultipartUploadRequest.multipartUpload();
            if (multipartUpload != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CompleteMultipartUpload");

                java.util.List<CompletedPart> completedMultipartUploadPartsList = multipartUpload.parts();
                if (completedMultipartUploadPartsList != null) {
                    for (CompletedPart completedMultipartUploadPartsListValue : completedMultipartUploadPartsList) {
                        xmlWriter.startElement("Part");

                        if (completedMultipartUploadPartsListValue.eTag() != null) {
                            xmlWriter.startElement("ETag").value(completedMultipartUploadPartsListValue.eTag()).endElement();
                        }

                        if (completedMultipartUploadPartsListValue.partNumber() != null) {
                            xmlWriter.startElement("PartNumber").value(completedMultipartUploadPartsListValue.partNumber())
                                    .endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}